/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrafficLightRenderer
implements ErrorStripeRenderer,
Disposable {
    private final Project myProject;
    private final Document myDocument;
    private final PsiFile myFile;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final SeverityRegistrar mySeverityRegistrar;
    private Icon icon;
    String statistics;
    String statusLabel;
    String statusExtraLine;
    boolean passStatusesVisible;
    final Map<ProgressableTextEditorHighlightingPass, Pair<JProgressBar, JLabel>> passes = ContainerUtil.newLinkedHashMap();
    static final int MAX = 100;
    boolean progressBarsEnabled;
    Boolean progressBarsCompleted;
    protected int[] errorCount;

    public TrafficLightRenderer(@Nullable Project project, Document document, PsiFile file2) {
        this.myProject = project;
        this.myDaemonCodeAnalyzer = project == null ? null : (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        this.myDocument = document;
        this.myFile = file2;
        this.mySeverityRegistrar = SeverityRegistrar.getSeverityRegistrar(this.myProject);
        this.refresh(null);
        if (project != null) {
            MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
            model.addMarkupModelListener(this, new MarkupModelListener(){

                @Override
                public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                    if (highlighter == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TrafficLightRenderer.this.incErrorCount(highlighter, 1);
                }

                @Override
                public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                    if (highlighter == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    TrafficLightRenderer.this.incErrorCount(highlighter, -1);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "highlighter";
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "afterAdded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            UIUtil.invokeLaterIfNeeded(() -> {
                for (RangeHighlighter rangeHighlighter : model.getAllHighlighters()) {
                    this.incErrorCount(rangeHighlighter, 1);
                }
            });
        }
    }

    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(0);
        }
        return severityRegistrar;
    }

    protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
        int maxIndex = this.mySeverityRegistrar.getSeverityMaxIndex();
        if (this.errorCount != null && maxIndex + 1 == this.errorCount.length) {
            return;
        }
        this.errorCount = new int[maxIndex + 1];
    }

    public void dispose() {
    }

    private void incErrorCount(RangeHighlighter highlighter, int delta) {
        HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
        if (info == null) {
            return;
        }
        HighlightSeverity infoSeverity = info.getSeverity();
        if (infoSeverity.myVal <= HighlightSeverity.INFORMATION.myVal) {
            return;
        }
        int severityIdx = this.mySeverityRegistrar.getSeverityIdx(infoSeverity);
        if (severityIdx != -1) {
            int n = severityIdx;
            this.errorCount[n] = this.errorCount[n] + delta;
        }
    }

    public boolean isValid() {
        return this.myFile == null || this.myFile.isValid();
    }

    @NotNull
    protected DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(1);
        }
        DaemonCodeAnalyzerStatus status = new DaemonCodeAnalyzerStatus();
        if (this.myFile == null) {
            status.reasonWhyDisabled = "No file";
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(2);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (this.myProject != null && this.myProject.isDisposed()) {
            status.reasonWhyDisabled = "Project is disposed";
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(3);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (!this.myDaemonCodeAnalyzer.isHighlightingAvailable(this.myFile)) {
            if (!this.myFile.isPhysical()) {
                status.reasonWhyDisabled = "File is generated";
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(4);
                }
                return daemonCodeAnalyzerStatus;
            }
            if (this.myFile instanceof PsiCompiledElement) {
                status.reasonWhyDisabled = "File is decompiled";
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(5);
                }
                return daemonCodeAnalyzerStatus;
            }
            FileType fileType = this.myFile.getFileType();
            if (fileType.isBinary()) {
                status.reasonWhyDisabled = "File is binary";
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(6);
                }
                return daemonCodeAnalyzerStatus;
            }
            status.reasonWhyDisabled = "Highlighting is disabled for this file";
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(7);
            }
            return daemonCodeAnalyzerStatus;
        }
        FileViewProvider provider = this.myFile.getViewProvider();
        Set languages = provider.getLanguages();
        HighlightingSettingsPerFile levelSettings = HighlightingSettingsPerFile.getInstance(this.myProject);
        boolean shouldHighlight = languages.isEmpty();
        for (Language language : languages) {
            PsiFile root = provider.getPsi(language);
            FileHighlightingSetting level = levelSettings.getHighlightingSettingForRoot((PsiElement)root);
            shouldHighlight |= level != FileHighlightingSetting.SKIP_HIGHLIGHTING;
        }
        if (!shouldHighlight) {
            status.reasonWhyDisabled = "Highlighting level is None";
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(8);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            status.reasonWhySuspended = StringUtil.defaultIfEmpty((String)HeavyProcessLatch.INSTANCE.getRunningOperationName(), (String)"Heavy operation is running");
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(9);
            }
            return daemonCodeAnalyzerStatus;
        }
        status.errorCount = (int[])this.errorCount.clone();
        List<TextEditorHighlightingPass> passes = this.myDaemonCodeAnalyzer.getPassesToShowProgressFor(this.myDocument);
        status.passStati = passes.isEmpty() ? Collections.emptyList() : new ArrayList(passes.size());
        for (int i = 0; i < passes.size(); ++i) {
            ProgressableTextEditorHighlightingPass pass;
            TextEditorHighlightingPass tepass = passes.get(i);
            if (!(tepass instanceof ProgressableTextEditorHighlightingPass) || StringUtil.isEmpty((String)((ProgressableTextEditorHighlightingPass)tepass).getPresentableName()) || (pass = (ProgressableTextEditorHighlightingPass)tepass).getProgress() < 0.0) continue;
            status.passStati.add(pass);
        }
        status.errorAnalyzingFinished = this.myDaemonCodeAnalyzer.isAllAnalysisFinished(this.myFile);
        status.reasonWhySuspended = this.myDaemonCodeAnalyzer.isUpdateByTimerEnabled() ? null : "Highlighting is paused temporarily";
        this.fillDaemonCodeAnalyzerErrorsStatus(status, severityRegistrar);
        DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
        if (daemonCodeAnalyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(10);
        }
        return daemonCodeAnalyzerStatus;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(11);
        }
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(12);
        }
    }

    protected final Project getProject() {
        return this.myProject;
    }

    public String getTooltipMessage() {
        return null;
    }

    public void paint(Component c, Graphics g, Rectangle r) {
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        Icon icon = this.getIcon(status);
        icon.paintIcon(c, g, r.x, r.y);
    }

    @NotNull
    private Icon getIcon(@NotNull DaemonCodeAnalyzerStatus status) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(13);
        }
        this.updatePanel(status);
        Icon icon = this.icon;
        if (PowerSaveMode.isEnabled() || status.reasonWhySuspended != null || status.reasonWhyDisabled != null || status.errorAnalyzingFinished) {
            Icon icon2 = icon;
            if (icon2 == null) {
                TrafficLightRenderer.$$$reportNull$$$0(14);
            }
            return icon2;
        }
        Icon icon3 = AllIcons.General.InspectionsEye;
        if (icon3 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(15);
        }
        return icon3;
    }

    boolean updatePanel(@NotNull DaemonCodeAnalyzerStatus status) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(16);
        }
        this.progressBarsEnabled = false;
        this.progressBarsCompleted = null;
        this.statistics = "";
        this.passStatusesVisible = false;
        this.statusLabel = null;
        this.statusExtraLine = null;
        boolean result2 = false;
        if (!status.passStati.equals(new ArrayList<ProgressableTextEditorHighlightingPass>(this.passes.keySet()))) {
            this.rebuildPassesMap(status);
            result2 = true;
        }
        if (PowerSaveMode.isEnabled()) {
            this.statusLabel = "Code analysis is disabled in power save mode";
            status.errorAnalyzingFinished = true;
            this.icon = AllIcons.General.SafeMode;
            return result2;
        }
        if (status.reasonWhyDisabled != null) {
            this.statusLabel = "No analysis has been performed";
            this.statusExtraLine = "(" + status.reasonWhyDisabled + ")";
            this.passStatusesVisible = true;
            this.progressBarsCompleted = Boolean.FALSE;
            this.icon = AllIcons.General.InspectionsTrafficOff;
            return result2;
        }
        if (status.reasonWhySuspended != null) {
            this.statusLabel = "Code analysis has been suspended";
            this.statusExtraLine = "(" + status.reasonWhySuspended + ")";
            this.passStatusesVisible = true;
            this.progressBarsCompleted = Boolean.FALSE;
            this.icon = AllIcons.General.InspectionsPause;
            return result2;
        }
        Icon icon = AllIcons.General.InspectionsOK;
        for (int i = status.errorCount.length - 1; i >= 0; --i) {
            if (status.errorCount[i] <= 0) continue;
            icon = this.mySeverityRegistrar.getRendererIconByIndex(i);
            break;
        }
        if (status.errorAnalyzingFinished) {
            boolean isDumb;
            boolean bl = isDumb = this.myProject != null && DumbService.isDumb((Project)this.myProject);
            if (isDumb) {
                this.statusLabel = "Shallow analysis completed";
                this.statusExtraLine = "Complete results will be available after indexing";
            } else {
                this.statusLabel = DaemonBundle.message((String)"analysis.completed", (Object[])new Object[0]);
            }
            this.progressBarsCompleted = Boolean.TRUE;
        } else {
            this.statusLabel = DaemonBundle.message((String)"performing.code.analysis", (Object[])new Object[0]);
            this.passStatusesVisible = true;
            this.progressBarsEnabled = true;
            this.progressBarsCompleted = null;
        }
        int currentSeverityErrors = 0;
        String text = "";
        for (int i = status.errorCount.length - 1; i >= 0; --i) {
            if (status.errorCount[i] <= 0) continue;
            HighlightSeverity severity = this.mySeverityRegistrar.getSeverityByIndex(i);
            String name = status.errorCount[i] > 1 ? StringUtil.pluralize((String)severity.getName().toLowerCase()) : severity.getName().toLowerCase();
            text = text + (status.errorAnalyzingFinished ? DaemonBundle.message((String)"errors.found", (Object[])new Object[]{status.errorCount[i], name}) : DaemonBundle.message((String)"errors.found.so.far", (Object[])new Object[]{status.errorCount[i], name}));
            text = text + "<br>";
            currentSeverityErrors += status.errorCount[i];
        }
        if (currentSeverityErrors == 0) {
            text = text + (status.errorAnalyzingFinished ? DaemonBundle.message((String)"no.errors.or.warnings.found", (Object[])new Object[0]) : DaemonBundle.message((String)"no.errors.or.warnings.found.so.far", (Object[])new Object[0]) + "<br>");
        }
        this.statistics = XmlStringUtil.wrapInHtml((CharSequence)text);
        this.icon = icon;
        return result2;
    }

    private void rebuildPassesMap(@NotNull DaemonCodeAnalyzerStatus status) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(17);
        }
        this.passes.clear();
        for (ProgressableTextEditorHighlightingPass pass : status.passStati) {
            JProgressBar progressBar = new JProgressBar(0, 100);
            progressBar.setMaximum(100);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)progressBar);
            JLabel percLabel = new JLabel();
            percLabel.setText("100%");
            this.passes.put(pass, (Pair<JProgressBar, JLabel>)Pair.create((Object)progressBar, (Object)percLabel));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityRegistrar";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillDaemonCodeAnalyzerErrorsStatus";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updatePanel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "rebuildPassesMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DaemonCodeAnalyzerStatus {
        public boolean errorAnalyzingFinished;
        List<ProgressableTextEditorHighlightingPass> passStati = Collections.emptyList();
        public int[] errorCount = ArrayUtil.EMPTY_INT_ARRAY;
        public String reasonWhyDisabled;
        public String reasonWhySuspended;

        public String toString() {
            String s = "DS: finished=" + this.errorAnalyzingFinished;
            s = s + "; pass statuses: " + this.passStati.size() + "; ";
            for (ProgressableTextEditorHighlightingPass passStatus : this.passStati) {
                s = s + String.format("(%s %2.0f%% %b)", passStatus.getPresentableName(), passStatus.getProgress() * 100.0, passStatus.isFinished());
            }
            s = s + "; error count: " + this.errorCount.length + ": " + new TIntArrayList(this.errorCount);
            return s;
        }
    }
}

