/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a\b\u0010\u000e\u001a\u00020\u000bH\u0002\u001a\b\u0010\u000f\u001a\u00020\u000bH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"runActionCustomShortcutSet", "Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "getRunActionCustomShortcutSet", "()Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "createActionLabel", "Lcom/intellij/ui/HyperlinkLabel;", "text", "", "action", "Ljava/lang/Runnable;", "background", "Ljava/awt/Color;", "getActionFont", "Ljava/awt/Font;", "getKeymapColor", "getSettingsIconHoverBackgroundColor", "intellij.platform.lang.impl"})
public final class DaemonTooltipWithActionRendererKt {
    @NotNull
    private static final CustomShortcutSet runActionCustomShortcutSet = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 576));

    @NotNull
    public static final CustomShortcutSet getRunActionCustomShortcutSet() {
        return runActionCustomShortcutSet;
    }

    @NotNull
    public static final HyperlinkLabel createActionLabel(@NotNull String text, @NotNull Runnable action, @NotNull Color background) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)background, (String)"background");
        HyperlinkLabel label2 = new HyperlinkLabel(text, background, text, background){
            final /* synthetic */ String $text;
            final /* synthetic */ Color $background;

            protected int getTextOffset() {
                return 0;
            }
            {
                this.$text = $captured_local_variable$0;
                this.$background = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        label2.setBorder((Border)JBUI.Borders.empty());
        label2.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(action){
            final /* synthetic */ Runnable $action;

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$action.run();
            }
            {
                this.$action = $captured_local_variable$0;
            }
        });
        Font toolTipFont = DaemonTooltipWithActionRendererKt.getActionFont();
        label2.setFont(toolTipFont);
        return label2;
    }

    private static final Color getKeymapColor() {
        JBColor jBColor = JBColor.namedColor((String)"tooltips.actions.keymap.text.color", (Color)((Color)new JBColor(10069165, 0x919191)));
        Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"JBColor.namedColor(\"tool\u2026olor(0x99a4ad, 0x919191))");
        return (Color)jBColor;
    }

    private static final Color getSettingsIconHoverBackgroundColor() {
        JBColor jBColor = JBColor.namedColor((String)"tooltips.actions.settings.icon.background.color", (Color)((Color)new JBColor(15329984, 0x44494C)));
        Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"JBColor.namedColor(\"tool\u2026olor(0xe9eac0, 0x44494c))");
        return (Color)jBColor;
    }

    private static final Font getActionFont() {
        Font toolTipFont = UIUtil.getToolTipFont();
        if (toolTipFont == null || SystemInfo.isWindows) {
            return toolTipFont;
        }
        if (Intrinsics.areEqual((Object)JBUI.Fonts.label(), (Object)toolTipFont) ^ true || UISettings.Companion.getInstance().getOverrideLafFonts()) {
            return toolTipFont;
        }
        if (SystemInfo.isMac) {
            return toolTipFont.deriveFont((float)toolTipFont.getSize() - 1.0f);
        }
        if (SystemInfo.isLinux) {
            return toolTipFont.deriveFont((float)toolTipFont.getSize() - 1.0f);
        }
        return toolTipFont;
    }

    @NotNull
    public static final /* synthetic */ Color access$getKeymapColor() {
        return DaemonTooltipWithActionRendererKt.getKeymapColor();
    }

    @Nullable
    public static final /* synthetic */ Font access$getActionFont() {
        return DaemonTooltipWithActionRendererKt.getActionFont();
    }

    @NotNull
    public static final /* synthetic */ Color access$getSettingsIconHoverBackgroundColor() {
        return DaemonTooltipWithActionRendererKt.getSettingsIconHoverBackgroundColor();
    }
}

