/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionInitializationUtil;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionLookupArrangerImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingService;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionServiceImpl
extends CompletionService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.impl.CompletionServiceImpl");
    private static volatile CompletionPhase ourPhase = CompletionPhase.NoCompletion;
    private static Throwable ourPhaseTrace;

    public CompletionServiceImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(Project project) {
                CompletionProgressIndicator indicator = CompletionServiceImpl.this.getCurrentCompletion();
                if (indicator != null && indicator.getProject() == project) {
                    indicator.closeAndFinish(true);
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                } else if (indicator == null) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }
        });
    }

    public static CompletionServiceImpl getCompletionService() {
        return (CompletionServiceImpl)CompletionService.getCompletionService();
    }

    public String getAdvertisementText() {
        CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        return completion == null ? null : (String)ContainerUtil.getFirstItem(completion.getLookup().getAdvertisements());
    }

    public void setAdvertisementText(@Nullable String text) {
        if (text == null) {
            return;
        }
        CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (completion != null) {
            completion.addAdvertisement(text, null);
        }
    }

    public CompletionParameters createCompletionParameters(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, int invocationCount, CompletionType completionType, @NotNull Disposable parentDisposable) {
        if (project == null) {
            CompletionServiceImpl.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CompletionServiceImpl.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            CompletionServiceImpl.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            CompletionServiceImpl.$$$reportNull$$$0(3);
        }
        CompletionInitializationContextImpl context = CompletionInitializationUtil.createCompletionInitializationContext(project, editor, caret, invocationCount, completionType);
        CompletionProcessBase progress = new CompletionProcessBase(context);
        Disposer.register((Disposable)parentDisposable, (Disposable)progress);
        return CompletionInitializationUtil.prepareCompletionParameters(context, progress);
    }

    public CompletionResultSet createResultSet(CompletionParameters parameters, Consumer<CompletionResult> consumer, @NotNull CompletionContributor contributor) {
        if (contributor == null) {
            CompletionServiceImpl.$$$reportNull$$$0(4);
        }
        PsiElement position = parameters.getPosition();
        int offset = parameters.getOffset();
        TextRange range2 = position.getTextRange();
        assert (range2.containsOffset(offset)) : position + "; " + offset + " not in " + range2;
        String prefix = CompletionData.findPrefixStatic(position, offset);
        CamelHumpMatcher matcher = new CamelHumpMatcher(prefix);
        CompletionSorterImpl sorter = this.defaultSorter(parameters, matcher);
        return new CompletionResultSetImpl(consumer, offset, matcher, contributor, parameters, sorter, null);
    }

    public CompletionProgressIndicator getCurrentCompletion() {
        if (CompletionServiceImpl.isPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.CommittingDocuments.class, CompletionPhase.Synchronous.class)) {
            return CompletionServiceImpl.ourPhase.indicator;
        }
        return null;
    }

    @SafeVarargs
    public static void assertPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(5);
        }
        if (!CompletionServiceImpl.isPhase(possibilities)) {
            LOG.error(ourPhase + "; set at " + ExceptionUtil.getThrowableText((Throwable)ourPhaseTrace));
        }
    }

    @SafeVarargs
    public static boolean isPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(6);
        }
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        for (Class<? extends CompletionPhase> possibility : possibilities) {
            if (!possibility.isInstance(phase)) continue;
            return true;
        }
        return false;
    }

    public static void setCompletionPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        CompletionProgressIndicator oldIndicator = oldPhase.indicator;
        if (oldIndicator != null && !(phase instanceof CompletionPhase.BgCalculation)) {
            LOG.assertTrue(!oldIndicator.isRunning() || oldIndicator.isCanceled(), (Object)("don't change phase during running completion: oldPhase=" + oldPhase));
        }
        Disposer.dispose((Disposable)oldPhase);
        ourPhase = phase;
        ourPhaseTrace = new Throwable();
    }

    public static CompletionPhase getCompletionPhase() {
        return ourPhase;
    }

    public CompletionSorterImpl defaultSorter(CompletionParameters parameters, PrefixMatcher matcher) {
        final CompletionLocation location = new CompletionLocation(parameters);
        CompletionSorterImpl sorter = this.emptySorter();
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new DispreferLiveTemplates()));
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new PreferStartMatching()));
        for (final Weigher weigher : WeighingService.getWeighers((Key)CompletionService.RELEVANCE_KEY)) {
            String id = weigher.toString();
            if ("prefix".equals(id)) {
                sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new RealPrefixMatchingWeigher()));
                continue;
            }
            if ("stats".equals(id)) {
                sorter = sorter.withClassifier(new ClassifierFactory<LookupElement>("stats"){

                    @Override
                    public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                        return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
                    }
                });
                continue;
            }
            sorter = sorter.weigh(new LookupElementWeigher(id, true, false){

                public Comparable weigh(@NotNull LookupElement element) {
                    if (element == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return weigher.weigh((Object)element, (Object)location);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$3", "weigh"));
                }
            });
        }
        return sorter.withClassifier("priority", true, new ClassifierFactory<LookupElement>("liftShorter"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
    }

    public CompletionSorterImpl emptySorter() {
        return new CompletionSorterImpl(new ArrayList<ClassifierFactory<LookupElement>>());
    }

    public CompletionLookupArranger createLookupArranger(CompletionParameters parameters) {
        return new CompletionLookupArrangerImpl(parameters);
    }

    public void handleCompletionItemSelected(CompletionParameters parameters, LookupElement lookupElement, PrefixMatcher prefixMatcher, char completionChar) {
        LookupImpl.insertLookupString(parameters.getPosition().getProject(), parameters.getEditor(), lookupElement, prefixMatcher, prefixMatcher.getPrefix(), prefixMatcher.getPrefix().length());
        CodeCompletionHandlerBase handler2 = CodeCompletionHandlerBase.createHandler(parameters.getCompletionType(), true, parameters.isAutoPopup(), true);
        handler2.handleCompletionElementSelected(parameters, lookupElement, completionChar);
    }

    public static boolean isStartMatch(LookupElement element, WeighingContext context) {
        return CompletionServiceImpl.getItemMatcher(element, context).isStartMatch(element);
    }

    static PrefixMatcher getItemMatcher(LookupElement element, WeighingContext context) {
        PrefixMatcher itemMatcher = context.itemMatcher(element);
        String pattern = context.itemPattern(element);
        if (!pattern.equals(itemMatcher.getPrefix())) {
            return itemMatcher.cloneWithPrefix(pattern);
        }
        return itemMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibilities";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCompletionParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createResultSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "assertPhase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPhase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setCompletionPhase";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CompletionResultSetImpl
    extends CompletionResultSet {
        private final int myLengthOfTextBeforePosition;
        private final CompletionParameters myParameters;
        private final CompletionSorterImpl mySorter;
        @Nullable
        private final CompletionResultSetImpl myOriginal;

        CompletionResultSetImpl(Consumer<CompletionResult> consumer, int lengthOfTextBeforePosition, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters, @NotNull CompletionSorterImpl sorter, @Nullable CompletionResultSetImpl original) {
            if (sorter == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(0);
            }
            super(prefixMatcher, consumer, contributor);
            this.myLengthOfTextBeforePosition = lengthOfTextBeforePosition;
            this.myParameters = parameters;
            this.mySorter = sorter;
            this.myOriginal = original;
        }

        public void addAllElements(@NotNull Iterable<? extends LookupElement> elements) {
            if (elements == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(1);
            }
            CompletionThreadingBase.withBatchUpdate(() -> {
                if (elements == null) {
                    CompletionResultSetImpl.$$$reportNull$$$0(12);
                }
                super.addAllElements(elements);
            }, this.myParameters.getProcess());
        }

        public void addElement(@NotNull LookupElement element) {
            if (element == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(2);
            }
            ProgressManager.checkCanceled();
            if (!element.isValid()) {
                LOG.error("Invalid lookup element: " + element + " of " + element.getClass() + " in " + this.myParameters.getOriginalFile() + " of " + this.myParameters.getOriginalFile().getClass());
                return;
            }
            CompletionResult matched = CompletionResult.wrap((LookupElement)element, (PrefixMatcher)this.getPrefixMatcher(), (CompletionSorter)this.mySorter);
            if (matched != null) {
                this.passResult(matched);
            }
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(3);
            }
            if (matcher.equals(this.getPrefixMatcher())) {
                CompletionResultSetImpl completionResultSetImpl = this;
                if (completionResultSetImpl == null) {
                    CompletionResultSetImpl.$$$reportNull$$$0(4);
                }
                return completionResultSetImpl;
            }
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl((Consumer<CompletionResult>)this.getConsumer(), this.myLengthOfTextBeforePosition, matcher, this.myContributor, this.myParameters, this.mySorter, this);
            if (completionResultSetImpl == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(5);
            }
            return completionResultSetImpl;
        }

        public void stopHere() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Completion stopped\n" + DebugUtil.currentStackTrace());
            }
            super.stopHere();
            if (this.myOriginal != null) {
                this.myOriginal.stopHere();
            }
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(6);
            }
            CompletionResultSet completionResultSet = this.withPrefixMatcher(this.getPrefixMatcher().cloneWithPrefix(prefix));
            if (completionResultSet == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(7);
            }
            return completionResultSet;
        }

        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(8);
            }
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl((Consumer<CompletionResult>)this.getConsumer(), this.myLengthOfTextBeforePosition, this.getPrefixMatcher(), this.myContributor, this.myParameters, (CompletionSorterImpl)sorter, this);
            if (completionResultSetImpl == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(9);
            }
            return completionResultSetImpl;
        }

        public void addLookupAdvertisement(@NotNull String text) {
            if (text == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(10);
            }
            CompletionServiceImpl.getCompletionService().setAdvertisementText(text);
        }

        @NotNull
        public CompletionResultSet caseInsensitive() {
            CompletionResultSet completionResultSet = this.withPrefixMatcher(new CamelHumpMatcher(this.getPrefixMatcher().getPrefix(), false));
            if (completionResultSet == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(11);
            }
            return completionResultSet;
        }

        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProgressIndicator) {
                ((CompletionProgressIndicator)process2).addWatchedPrefix(this.myLengthOfTextBeforePosition - this.getPrefixMatcher().getPrefix().length(), prefixCondition);
            }
        }

        public void restartCompletionWhenNothingMatches() {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProgressIndicator) {
                ((CompletionProgressIndicator)process2).getLookup().setStartCompletionWhenNothingMatches(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorter";
                    break;
                }
                case 1: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixMatcher";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelevanceSorter";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "caseInsensitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addAllElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixMatcher";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelevanceSorter";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupAdvertisement";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addAllElements$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

