/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class CompositeView<T extends ComponentContainer>
extends JPanel
implements ComponentContainer,
DataProvider {
    private final Map<String, T> myViewMap = ContainerUtil.newConcurrentMap();
    private final String mySelectionStateKey;
    private final AtomicReference<String> myEnabledViewRef = new AtomicReference();
    @NotNull
    private final SwitchViewAction mySwitchViewAction;

    public CompositeView(String selectionStateKey) {
        super(new CardLayout());
        this.mySelectionStateKey = selectionStateKey;
        this.mySwitchViewAction = new SwitchViewAction();
    }

    public void addView(T view, String viewName, boolean enable) {
        T oldView = this.getView(viewName);
        if (oldView != null) {
            this.remove(oldView.getComponent());
            Disposer.dispose(oldView);
        }
        this.myViewMap.put(viewName, view);
        this.add((Component)view.getComponent(), viewName);
        String storedState = this.getStoredState();
        if (storedState != null && storedState.equals(viewName) || storedState == null && enable) {
            this.enableView(viewName);
            this.setStoredState(viewName);
        }
        Disposer.register((Disposable)this, view);
    }

    public void enableView(@NotNull String viewName) {
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(0);
        }
        if (!StringUtil.equals((CharSequence)viewName, (CharSequence)this.myEnabledViewRef.get())) {
            this.myEnabledViewRef.set(viewName);
            CardLayout cl = (CardLayout)this.getLayout();
            cl.show(this, viewName);
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            T view;
            if (viewName == null) {
                CompositeView.$$$reportNull$$$0(6);
            }
            if ((view = this.getView(viewName)) != null) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)view.getPreferredFocusableComponent(), true);
            }
        });
    }

    public boolean isViewEnabled(String viewName) {
        return StringUtil.equals((CharSequence)this.myEnabledViewRef.get(), (CharSequence)viewName);
    }

    public T getView(@NotNull String viewName) {
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(1);
        }
        return (T)((ComponentContainer)this.myViewMap.get(viewName));
    }

    @Nullable
    public <U> U getView(@NotNull String viewName, @NotNull Class<U> viewClass) {
        T view;
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(2);
        }
        if (viewClass == null) {
            CompositeView.$$$reportNull$$$0(3);
        }
        return viewClass.isInstance(view = this.getView(viewName)) ? (U)viewClass.cast(view) : null;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            CompositeView.$$$reportNull$$$0(4);
        }
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    public AnAction[] getSwitchActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addSeparator();
        actionGroup.add((AnAction)this.mySwitchViewAction);
        AnAction[] anActionArray = new AnAction[]{actionGroup};
        if (anActionArray == null) {
            CompositeView.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getPreferredFocusableComponent() {
        return this;
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        Object data;
        T enabledView;
        String enabledViewName = this.myEnabledViewRef.get();
        if (enabledViewName != null && (enabledView = this.getView(enabledViewName)) instanceof DataProvider && (data = ((DataProvider)enabledView).getData(dataId)) != null) {
            return data;
        }
        return null;
    }

    private void setStoredState(String viewName) {
        if (this.mySelectionStateKey != null) {
            PropertiesComponent.getInstance().setValue(this.mySelectionStateKey, viewName);
        }
    }

    @Nullable
    private String getStoredState() {
        return this.mySelectionStateKey == null ? null : PropertiesComponent.getInstance().getValue(this.mySelectionStateKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/CompositeView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/CompositeView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enableView";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getView";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$enableView$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SwitchViewAction
    extends ToggleAction
    implements DumbAware {
        public SwitchViewAction() {
            super("Toggle view", null, AllIcons.Actions.ChangeView);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchViewAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            if (CompositeView.this.myViewMap.size() <= 1) {
                presentation.setEnabled(false);
            } else {
                presentation.setEnabled(true);
                presentation.putClientProperty("selected", (Object)this.isSelected(e));
            }
        }

        public boolean isSelected(AnActionEvent event) {
            String enabledViewName = (String)CompositeView.this.myEnabledViewRef.get();
            if (enabledViewName == null) {
                return true;
            }
            Set viewNames = CompositeView.this.myViewMap.keySet();
            return viewNames.isEmpty() || enabledViewName.equals(viewNames.iterator().next());
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            if (CompositeView.this.myViewMap.size() > 1) {
                ArrayList names = new ArrayList(CompositeView.this.myViewMap.keySet());
                String viewName = flag ? (String)names.get(0) : (String)names.get(1);
                CompositeView.this.enableView(viewName);
                CompositeView.this.setStoredState(viewName);
                ApplicationManager.getApplication().invokeLater(() -> this.update(event));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/CompositeView$SwitchViewAction", "update"));
        }
    }
}

