/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroExpandableProtocolBean;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex = null;
    private final Map<String, String> myMacroMap = ContainerUtilRt.newLinkedHashMap();
    @NonNls
    public static final String[] PROTOCOLS;

    public void addMacroReplacement(String path, String macroName) {
        this.addReplacement(FileUtil.toSystemIndependentName((String)path), "$" + macroName + "$", true);
    }

    public void addReplacement(String path, String macroExpr, boolean overwrite) {
        path = StringUtil.trimEnd((String)path, (String)"/");
        this.putIfAbsent(path, macroExpr, overwrite);
        for (String protocol : PROTOCOLS) {
            this.putIfAbsent(protocol + ":" + path, protocol + ":" + macroExpr, overwrite);
            this.putIfAbsent(protocol + ":/" + path, protocol + ":/" + macroExpr, overwrite);
            this.putIfAbsent(protocol + "://" + path, protocol + "://" + macroExpr, overwrite);
        }
    }

    private void putIfAbsent(String path, String substitution, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path)) {
            this.myMacroMap.put(path, substitution);
        }
    }

    public String substitute(@Nullable String text, boolean caseSensitive) {
        if (text == null) {
            return null;
        }
        for (String path : this.getPathIndex()) {
            text = this.replacePathMacro(text, path, caseSensitive);
        }
        return text;
    }

    private String replacePathMacro(@NotNull String text, @NotNull String path, boolean caseSensitive) {
        boolean startsWith;
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(1);
        }
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        boolean bl = startsWith = caseSensitive ? text.startsWith(path) : StringUtil.startsWithIgnoreCase((String)text, (String)path);
        if (!startsWith) {
            return text;
        }
        int endOfOccurrence = path.length();
        boolean isWindowsRoot = path.endsWith(":/");
        if (!isWindowsRoot && endOfOccurrence < text.length() && text.charAt(endOfOccurrence) != '/' && !text.substring(endOfOccurrence).startsWith("!/")) {
            return text;
        }
        return this.myMacroMap.get(path) + text.substring(endOfOccurrence);
    }

    @NotNull
    public String substituteRecursively(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(2);
        }
        for (String path : this.getPathIndex()) {
            text = this.replacePathMacroRecursively(text, path, caseSensitive);
        }
        String string = text;
        if (string == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(3);
        }
        return string;
    }

    private String replacePathMacroRecursively(@NotNull String text, @NotNull String path, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(4);
        }
        if (path == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(5);
        }
        if (text.length() < path.length()) {
            return text;
        }
        if (path.isEmpty()) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path.endsWith(":/");
        int i = 0;
        while (i < text.length()) {
            int occurrenceOfPath;
            int n = occurrenceOfPath = caseSensitive ? text.indexOf(path, i) : StringUtil.indexOfIgnoreCase((String)text, (String)path, (int)i);
            if (occurrenceOfPath >= 0) {
                char prev2;
                int endOfOccurrence = occurrenceOfPath + path.length();
                if (!isWindowsRoot && endOfOccurrence < text.length() && text.charAt(endOfOccurrence) != '/' && text.charAt(endOfOccurrence) != '\"' && text.charAt(endOfOccurrence) != ' ' && !text.substring(endOfOccurrence).startsWith("!/")) {
                    newText.append(text, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev2 = text.charAt(occurrenceOfPath - 1)) || prev2 == '_')) {
                    newText.append(text, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.length() == 0) {
                    return text;
                }
                newText.append(text.substring(i));
                break;
            }
            newText.append(text, i, occurrenceOfPath);
            newText.append(this.myMacroMap.get(path));
            i = occurrenceOfPath + path.length();
        }
        return newText.toString();
    }

    private static int getIndex(@NotNull Map.Entry<String, String> s) {
        String replacement;
        if (s == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(6);
        }
        if ((replacement = s.getValue()).contains("..")) {
            return 1;
        }
        if (replacement.contains("$USER_HOME$")) {
            return 1;
        }
        if (replacement.contains("$APPLICATION_HOME_DIR$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$")) {
            return 3;
        }
        if (replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key) {
        if (key == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(7);
        }
        key = StringUtil.trimStart((String)key, (String)"jar:");
        key = StringUtil.trimStart((String)key, (String)"file:");
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        return key.length();
    }

    @NotNull
    public List<String> getPathIndex() {
        if (this.myPathsIndex == null || this.myPathsIndex.size() != this.myMacroMap.size()) {
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
            TObjectIntHashMap weights = new TObjectIntHashMap();
            for (Map.Entry entry2 : entries) {
                weights.put((Object)entry2, ReplacePathToMacroMap.getIndex(entry2) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
            }
            ContainerUtil.sort(entries, (o1, o2) -> weights.get(o2) - weights.get(o1));
            this.myPathsIndex = ContainerUtil.map2List(entries, entry -> (String)entry.getKey());
        }
        List<String> list2 = this.myPathsIndex;
        if (list2 == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)((Object)obj)).myMacroMap);
    }

    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path, String replacement) {
        this.myMacroMap.put(path, replacement);
    }

    static {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("file");
        protocols.add("jar");
        if (Extensions.getRootArea().hasExtensionPoint(PathMacroExpandableProtocolBean.EP_NAME.getName())) {
            for (PathMacroExpandableProtocolBean bean : (PathMacroExpandableProtocolBean[])PathMacroExpandableProtocolBean.EP_NAME.getExtensions()) {
                protocols.add(bean.protocol);
            }
        }
        PROTOCOLS = ArrayUtil.toStringArray(protocols);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteRecursively";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacro";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "substituteRecursively";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacroRecursively";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

