/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt;

import java.rmi.RemoteException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.intellij.plugins.xslt.run.rt.XSLTMain;
import org.intellij.plugins.xslt.run.rt.XSLTRunner;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon.SaxonSupport;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9Support;
import org.intellij.plugins.xsltDebugger.rt.engine.local.xalan.XalanSupport;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.DebuggerServer;

public class XSLTDebuggerMain
implements XSLTMain {
    public TransformerFactory createTransformerFactory() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String type = System.getProperty("xslt.transformer.type");
        if ("xalan".equalsIgnoreCase(type)) {
            return XalanSupport.createTransformerFactory();
        }
        if ("saxon".equalsIgnoreCase(type)) {
            return SaxonSupport.createTransformerFactory();
        }
        if ("saxon9".equalsIgnoreCase(type)) {
            return Saxon9Support.createTransformerFactory();
        }
        if (type != null) {
            throw new UnsupportedOperationException("Unsupported Transformer type '" + type + "'");
        }
        return XalanSupport.prepareFactory(XSLTRunner.createTransformerFactoryStatic());
    }

    public void start(Transformer transformer, Source source, Result result) throws TransformerException {
        try {
            DebuggerServer.create(transformer, source, result, Integer.getInteger("xslt.debugger.port"));
        }
        catch (RemoteException e) {
            throw new TransformerException(e.getMessage(), e.getCause());
        }
    }
}

