/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.testDiscovery;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testDiscovery.TestDiscoveryConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JUnitTestDiscoveryConfigurationProducer
extends TestDiscoveryConfigurationProducer {
    protected JUnitTestDiscoveryConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    protected void setPosition(JavaTestConfigurationBase configuration, PsiLocation<PsiMethod> position) {
        ((JUnitConfiguration)configuration).beFromSourcePosition(position);
    }

    protected Pair<String, String> getPosition(JavaTestConfigurationBase configuration) {
        JUnitConfiguration.Data data = ((JUnitConfiguration)configuration).getPersistentData();
        if (data.TEST_OBJECT.equals("source location")) {
            return Pair.create((Object)data.getMainClassName(), (Object)data.getMethodName());
        }
        return null;
    }

    public boolean isApplicable(@NotNull Location<PsiMethod> testMethod) {
        if (testMethod == null) {
            JUnitTestDiscoveryConfigurationProducer.$$$reportNull$$$0(0);
        }
        return JUnitUtil.isTestMethod(testMethod);
    }

    @NotNull
    public RunProfileState createProfile(@NotNull Location<PsiMethod>[] testMethods, Module module, RunConfiguration configuration, ExecutionEnvironment environment) {
        if (testMethods == null) {
            JUnitTestDiscoveryConfigurationProducer.$$$reportNull$$$0(1);
        }
        JUnitConfiguration.Data data = ((JUnitConfiguration)configuration).getPersistentData();
        data.setPatterns(Arrays.stream(testMethods).map(method -> {
            Iterator ancestors = method.getAncestors(PsiClass.class, true);
            return ((PsiClass)((Location)ancestors.next()).getPsiElement()).getQualifiedName() + "," + ((PsiMethod)method.getPsiElement()).getName();
        }).collect(Collectors.toCollection(LinkedHashSet::new)));
        data.TEST_OBJECT = "pattern";
        TestsPattern testsPattern = new TestsPattern((JUnitConfiguration)configuration, environment);
        if (testsPattern == null) {
            JUnitTestDiscoveryConfigurationProducer.$$$reportNull$$$0(2);
        }
        return testsPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethods";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfigurationProducer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createProfile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

