/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight.references;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSourceReference
extends PsiReferenceBase<PsiLiteral> {
    public MethodSourceReference(PsiLiteral element) {
        super((PsiElement)element, false);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            MethodSourceReference.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiMethod) {
            return this.handleElementRename(((PsiMethod)element).getName());
        }
        return super.bindToElement(element);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String methodName = this.getValue();
        String className = StringUtil.getPackageName((String)methodName, (char)'#');
        boolean selfClassReference = className.isEmpty() || JavaPsiFacade.getInstance((Project)((PsiLiteral)this.getElement()).getProject()).findClass(className, ((PsiLiteral)this.getElement()).getResolveScope()) == null;
        return super.handleElementRename(selfClassReference ? newElementName : className + '#' + newElementName);
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
        if (cls != null) {
            PsiClass aClass;
            String methodName = this.getValue();
            String className = StringUtil.getPackageName((String)methodName, (char)'#');
            if (!className.isEmpty() && (aClass = JavaPsiFacade.getInstance((Project)cls.getProject()).findClass(className, cls.getResolveScope())) != null) {
                cls = aClass;
                methodName = StringUtil.getShortName((String)methodName, (char)'#');
            }
            PsiMethod[] methods = cls.findMethodsByName(methodName, false);
            return Arrays.stream(methods).filter(MethodSourceReference::staticNoParams).findFirst().orElse(methods.length == 0 ? null : methods[0]);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElement> list = new ArrayList<LookupElement>();
        PsiClass topLevelClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
        if (topLevelClass != null) {
            PsiMethod[] methods;
            PsiMethod current = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiMethod.class);
            for (PsiMethod method : methods = topLevelClass.getMethods()) {
                if (current != null && method.getName().equals(current.getName()) || !MethodSourceReference.staticNoParams(method)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)method);
                list.add(builder.withAutoCompletionPolicy(AutoCompletionPolicy.SETTINGS_DEPENDENT));
            }
        }
        Object[] objectArray = list.toArray();
        if (objectArray == null) {
            MethodSourceReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private static boolean staticNoParams(PsiMethod method) {
        return method.hasModifierProperty("static") && method.getParameterList().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/codeInsight/references/MethodSourceReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/codeInsight/references/MethodSourceReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

