/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.TestClassCollector;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestCategory;
import com.intellij.execution.junit.TestClass;
import com.intellij.execution.junit.TestDirectory;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.junit.TestTags;
import com.intellij.execution.junit.TestUniqueId;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.junit.testDiscovery.TestBySource;
import com.intellij.execution.junit.testDiscovery.TestsByChanges;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.junit4.JUnit4IdeaTestRunner;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.spi.SPIFileType;
import com.intellij.spi.psi.SPIClassProviderReferenceElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public abstract class TestObject
extends JavaTestFrameworkRunnableState<JUnitConfiguration> {
    private static final String DEBUG_RT_PATH = "idea.junit_rt.path";
    protected static final Logger LOG = Logger.getInstance(TestObject.class);
    private static final String MESSAGE = ExecutionBundle.message((String)"configuration.not.speficied.message", (Object[])new Object[0]);
    @NonNls
    private static final String JUNIT_TEST_FRAMEWORK_NAME = "JUnit";
    private final JUnitConfiguration myConfiguration;
    protected File myListenersFile;
    private String myRunner;

    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<T, String> nameFunction, String packageName, boolean createTempFile, JavaParameters javaParameters) throws CantRunException {
        try {
            if (createTempFile) {
                this.createTempFiles(javaParameters);
            }
            TreeMap<Module, List<Object>> perModule = this.forkPerModule() ? new TreeMap<Module, List<Object>>((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true)) : null;
            ArrayList<String> testNames = new ArrayList<String>();
            if (elements.isEmpty() && perModule != null) {
                TestSearchScope scope;
                PsiPackage aPackage;
                SourceScope sourceScope = this.getSourceScope();
                Project project = this.getConfiguration().getProject();
                if (sourceScope != null && packageName != null && "-junit5".equals(this.getRunner()) && (aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(packageName)) != null && (scope = this.getScope()) != null) {
                    PsiDirectory[] directories;
                    GlobalSearchScope configurationSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project).intersectWith(sourceScope.getGlobalSearchScope());
                    for (PsiDirectory directory : directories = aPackage.getDirectories(configurationSearchScope)) {
                        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project);
                        if (module == null) continue;
                        perModule.put(module, Collections.emptyList());
                    }
                }
            }
            for (Object element : elements) {
                String name = (String)nameFunction.fun(element);
                if (name == null) continue;
                PsiElement psiElement = this.retrievePsiElement(element);
                if (perModule != null && psiElement != null) {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                    if (module == null) continue;
                    ArrayList<String> list = (ArrayList<String>)perModule.get(module);
                    if (list == null) {
                        list = new ArrayList<String>();
                        perModule.put(module, list);
                    }
                    list.add(name);
                    continue;
                }
                testNames.add(name);
            }
            JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
            if (perModule != null) {
                for (List perModuleClasses : perModule.values()) {
                    Collections.sort(perModuleClasses);
                    testNames.addAll(perModuleClasses);
                }
            } else if ("package".equals(data.TEST_OBJECT)) {
                Collections.sort(testNames);
            }
            String category = "category".equals(data.TEST_OBJECT) ? data.getCategory() : ("tags".equals(data.TEST_OBJECT) ? data.getTags().replaceAll(" ", "") : "");
            String filters = "pattern".equals(data.TEST_OBJECT) ? data.getPatternPresentation() : "";
            JUnitStarter.printClassesList(testNames, (String)packageName, (String)category, (String)filters, (File)this.myTempFile);
            this.writeClassesPerModule(packageName, javaParameters, perModule);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public Module[] getModulesToCompile() {
        SourceScope sourceScope = this.getSourceScope();
        return sourceScope != null ? sourceScope.getModulesToCompile() : Module.EMPTY_ARRAY;
    }

    protected TestObject(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(environment);
        this.myConfiguration = configuration;
    }

    public abstract String suggestActionName();

    public abstract RefactoringElementListener getListener(PsiElement var1, JUnitConfiguration var2);

    public abstract boolean isConfiguredByElement(JUnitConfiguration var1, PsiClass var2, PsiMethod var3, PsiPackage var4, PsiDirectory var5);

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
    }

    @Nullable
    public SourceScope getSourceScope() {
        return SourceScope.modules((Module[])this.getConfiguration().getModules());
    }

    protected void configureRTClasspath(JavaParameters javaParameters) throws CantRunException {
        String path = System.getProperty(DEBUG_RT_PATH);
        javaParameters.getClassPath().add(path != null ? path : PathUtil.getJarPathForClass(JUnitStarter.class));
        javaParameters.getClassPath().add(TestObject.getJUnit5RtFile());
        String preferredRunner = this.getRunner();
        if ("-junit5".equals(preferredRunner)) {
            Project project = this.getConfiguration().getProject();
            GlobalSearchScope globalSearchScope = TestObject.getScopeForJUnit(((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule(), project);
            this.appendJUnit5LauncherClasses(javaParameters, project, globalSearchScope);
        }
    }

    public static File getJUnit5RtFile() {
        File junit4Rt = new File(PathUtil.getJarPathForClass(JUnit4IdeaTestRunner.class));
        String junit4Name = junit4Rt.getName();
        String junit5Name = junit4Rt.isDirectory() ? junit4Name.replace("junit", "junit.v5") : junit4Name.replace("junit", "junit5");
        return new File(junit4Rt.getParent(), junit5Name);
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        String preferredRunner;
        JavaParameters javaParameters = super.createJavaParameters();
        javaParameters.setMainClass("com.intellij.rt.execution.junit.JUnitStarter");
        javaParameters.getProgramParametersList().add("-ideVersion5");
        StringBuilder buf = new StringBuilder();
        this.collectListeners(javaParameters, buf, "com.intellij.junitListener", "\n");
        if (buf.length() > 0) {
            try {
                this.myListenersFile = FileUtil.createTempFile((String)"junit_listeners_", (String)"", (boolean)true);
                javaParameters.getProgramParametersList().add("@@" + this.myListenersFile.getPath());
                FileUtil.writeToFile((File)this.myListenersFile, (byte[])buf.toString().getBytes(CharsetToolkit.UTF8_CHARSET));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if ((preferredRunner = this.getRunner()) != null) {
            javaParameters.getProgramParametersList().add(preferredRunner);
        }
        return javaParameters;
    }

    public void appendJUnit5LauncherClasses(JavaParameters javaParameters, Project project, GlobalSearchScope globalSearchScope) throws CantRunException {
        PathsList classPath = javaParameters.getClassPath();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass classFromCommon = (PsiClass)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> psiFacade.findClass("org.junit.platform.commons.JUnitException", globalSearchScope));
        String launcherVersion = TestObject.getVersion(classFromCommon);
        if (launcherVersion == null) {
            LOG.info("Failed to detect junit 5 launcher version, please configure explicit dependency");
            return;
        }
        if (!TestObject.hasPackageWithDirectories(psiFacade, "org.junit.platform.launcher", globalSearchScope)) {
            TestObject.downloadDependenciesWhenRequired(project, classPath, new RepositoryLibraryProperties("org.junit.platform", "junit-platform-launcher", launcherVersion));
        }
        if (!TestObject.hasPackageWithDirectories(psiFacade, "org.junit.platform.engine", globalSearchScope) || !this.isCustomJUnit5(globalSearchScope)) {
            PsiClass testAnnotation = (PsiClass)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> psiFacade.findClass("org.junit.jupiter.api.Test", globalSearchScope));
            String jupiterVersion = (String)ObjectUtils.notNull((Object)TestObject.getVersion(testAnnotation), (Object)"5.0.0");
            if (!TestObject.hasPackageWithDirectories(psiFacade, "org.junit.jupiter.engine", globalSearchScope) && TestObject.hasPackageWithDirectories(psiFacade, "org.junit.jupiter.api", globalSearchScope)) {
                TestObject.downloadDependenciesWhenRequired(project, classPath, new RepositoryLibraryProperties("org.junit.jupiter", "junit-jupiter-engine", jupiterVersion));
            }
            if (!TestObject.hasPackageWithDirectories(psiFacade, "org.junit.vintage", globalSearchScope) && TestObject.hasPackageWithDirectories(psiFacade, "junit.framework", globalSearchScope)) {
                String version = StringUtil.compareVersionNumbers((String)launcherVersion, (String)"1.1.0") < 0 ? "4.12." + StringUtil.getShortName((String)launcherVersion) : jupiterVersion;
                TestObject.downloadDependenciesWhenRequired(project, classPath, new RepositoryLibraryProperties("org.junit.vintage", "junit-vintage-engine", version));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersion(PsiClass classFromCommon) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)classFromCommon);
        if (virtualFile == null) {
            return null;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)classFromCommon.getProject());
        VirtualFile root = index.getClassRootForFile(virtualFile);
        if (root == null) return null;
        if (!(root.getFileSystem() instanceof JarFileSystem)) return null;
        VirtualFile manifestFile = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifestFile == null) {
            return null;
        }
        try (InputStream inputStream = manifestFile.getInputStream();){
            String string = new Manifest(inputStream).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void downloadDependenciesWhenRequired(Project project, PathsList classPath, RepositoryLibraryProperties properties) throws CantRunException {
        Collection roots = JarRepositoryManager.loadDependenciesModal((Project)project, (RepositoryLibraryProperties)properties, (boolean)false, (boolean)false, null, null);
        if (roots.isEmpty()) {
            throw new CantRunException("Failed to resolve " + properties.getMavenId());
        }
        for (OrderRoot root : roots) {
            if (root.getType() != OrderRootType.CLASSES) continue;
            classPath.add(root.getFile());
        }
    }

    private static boolean hasPackageWithDirectories(JavaPsiFacade psiFacade, String packageQName, GlobalSearchScope globalSearchScope) {
        PsiPackage aPackage = psiFacade.findPackage(packageQName);
        return aPackage != null && aPackage.getDirectories(globalSearchScope).length > 0;
    }

    private static GlobalSearchScope getScopeForJUnit(@Nullable Module module, Project project) {
        return module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)project);
    }

    public static GlobalSearchScope getScopeForJUnit(JUnitConfiguration configuration) {
        return TestObject.getScopeForJUnit(((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule(), configuration.getProject());
    }

    @NotNull
    protected OSProcessHandler createHandler(Executor executor) throws ExecutionException {
        this.appendForkInfo(executor);
        this.appendRepeatMode();
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(this.createCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        SearchForTestsTask searchForTestsTask = this.createSearchingForTestsTask();
        if (searchForTestsTask != null) {
            searchForTestsTask.attachTaskToProcess((OSProcessHandler)processHandler);
        }
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            TestObject.$$$reportNull$$$0(0);
        }
        return killableColoredProcessHandler;
    }

    public void appendRepeatMode() throws ExecutionException {
        String repeatMode = this.getConfiguration().getRepeatMode();
        if (!"Once".equals(repeatMode)) {
            int repeatCount = this.getConfiguration().getRepeatCount();
            String countString = "N Times".equals(repeatMode) && repeatCount > 0 ? RepeatCount.getCountString((int)repeatCount) : repeatMode;
            this.getJavaParameters().getProgramParametersList().add(countString);
        }
    }

    protected boolean isIdBasedTestTree() {
        return "-junit5".equals(this.getRunner());
    }

    @NotNull
    protected String getForkMode() {
        String string = this.getConfiguration().getForkMode();
        if (string == null) {
            TestObject.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static TestObject fromString(String id, JUnitConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            TestObject.$$$reportNull$$$0(2);
        }
        if ("method".equals(id)) {
            return new TestMethod(configuration, environment);
        }
        if ("class".equals(id)) {
            return new TestClass(configuration, environment);
        }
        if ("package".equals(id)) {
            return new TestPackage(configuration, environment);
        }
        if ("directory".equals(id)) {
            return new TestDirectory(configuration, environment);
        }
        if ("category".equals(id)) {
            return new TestCategory(configuration, environment);
        }
        if ("pattern".equals(id)) {
            return new TestsPattern(configuration, environment);
        }
        if ("uniqueId".equals(id)) {
            return new TestUniqueId(configuration, environment);
        }
        if ("tags".equals(id)) {
            return new TestTags(configuration, environment);
        }
        if ("source location".equals(id)) {
            return new TestBySource(configuration, environment);
        }
        if ("changes".equals(id)) {
            return new TestsByChanges(configuration, environment);
        }
        LOG.info(MESSAGE + id);
        return null;
    }

    protected PsiElement retrievePsiElement(Object element) {
        if (element instanceof String) {
            SourceScope scope = this.getSourceScope();
            Project project = this.getConfiguration().getProject();
            String qName = (String)element;
            int idx = qName.indexOf(44);
            String className = idx > 0 ? qName.substring(0, idx) : qName;
            return JavaPsiFacade.getInstance((Project)project).findClass(className, scope != null ? scope.getGlobalSearchScope() : GlobalSearchScope.projectScope((Project)project));
        }
        return element instanceof PsiElement ? (PsiElement)element : null;
    }

    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.myListenersFile != null) {
            FileUtil.delete((File)this.myListenersFile);
        }
    }

    @NotNull
    protected String getFrameworkName() {
        if (JUNIT_TEST_FRAMEWORK_NAME == null) {
            TestObject.$$$reportNull$$$0(3);
        }
        return JUNIT_TEST_FRAMEWORK_NAME;
    }

    @NotNull
    protected String getFrameworkId() {
        if ("junit" == null) {
            TestObject.$$$reportNull$$$0(4);
        }
        return "junit";
    }

    protected void passTempFile(ParametersList parametersList, String tempFilePath) {
        parametersList.add("@" + tempFilePath);
    }

    @NotNull
    public JUnitConfiguration getConfiguration() {
        JUnitConfiguration jUnitConfiguration = this.myConfiguration;
        if (jUnitConfiguration == null) {
            TestObject.$$$reportNull$$$0(5);
        }
        return jUnitConfiguration;
    }

    protected TestSearchScope getScope() {
        return this.getConfiguration().getPersistentData().getScope();
    }

    protected void passForkMode(String forkMode, File tempFile, JavaParameters parameters) throws ExecutionException {
        parameters.getProgramParametersList().add("@@@" + forkMode + ',' + tempFile.getAbsolutePath());
        if (this.getForkSocket() != null) {
            parameters.getProgramParametersList().add("-debugSocket" + this.getForkSocket().getLocalPort());
        }
    }

    protected String getRunner() {
        if (this.myRunner == null) {
            this.myRunner = this.getRunnerInner();
        }
        return this.myRunner;
    }

    private String getRunnerInner() {
        PsiClass psiClass;
        GlobalSearchScope globalSearchScope = TestObject.getScopeForJUnit(this.myConfiguration);
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        Project project = this.myConfiguration.getProject();
        boolean isMethodConfiguration = "method".equals(data.TEST_OBJECT);
        boolean isClassConfiguration = "class".equals(data.TEST_OBJECT);
        PsiClass psiClass2 = psiClass = isMethodConfiguration || isClassConfiguration ? JavaExecutionUtil.findMainClass((Project)project, (String)data.getMainClassName(), (GlobalSearchScope)globalSearchScope) : null;
        if (psiClass != null) {
            PsiMethod[] methods;
            if (JUnitUtil.isJUnit5TestClass((PsiClass)psiClass, (boolean)false)) {
                return "-junit5";
            }
            if (isClassConfiguration || JUnitUtil.isJUnit4TestClass((PsiClass)psiClass)) {
                return "-junit4";
            }
            String methodName = data.getMethodName();
            for (PsiMethod method : methods = psiClass.findMethodsByName(methodName, true)) {
                if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
                return "-junit4";
            }
            return "-junit3";
        }
        return JUnitUtil.isJUnit5((GlobalSearchScope)globalSearchScope, (Project)project) || this.isCustomJUnit5(globalSearchScope) ? "-junit5" : null;
    }

    private boolean isCustomJUnit5(GlobalSearchScope globalSearchScope) {
        Project project = this.myConfiguration.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        if (DumbService.isDumb((Project)project)) {
            return this.findCustomJUnit5TestEngineUsingClassLoader(globalSearchScope, project, psiFacade);
        }
        return TestObject.findCustomJunit5TestEngineUsingPsi(globalSearchScope, project, psiFacade);
    }

    private boolean findCustomJUnit5TestEngineUsingClassLoader(@NotNull GlobalSearchScope globalSearchScope, @NotNull Project project, @NotNull JavaPsiFacade psiFacade) {
        if (globalSearchScope == null) {
            TestObject.$$$reportNull$$$0(6);
        }
        if (project == null) {
            TestObject.$$$reportNull$$$0(7);
        }
        if (psiFacade == null) {
            TestObject.$$$reportNull$$$0(8);
        }
        if (DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> {
            if (psiFacade == null) {
                TestObject.$$$reportNull$$$0(12);
            }
            if (globalSearchScope == null) {
                TestObject.$$$reportNull$$$0(13);
            }
            PsiClass testEngine = (PsiClass)ReadAction.compute(() -> {
                if (psiFacade == null) {
                    TestObject.$$$reportNull$$$0(14);
                }
                if (globalSearchScope == null) {
                    TestObject.$$$reportNull$$$0(15);
                }
                return psiFacade.findClass("org.junit.platform.engine.TestEngine", globalSearchScope);
            });
            return testEngine;
        }) == null) {
            return false;
        }
        ClassLoader loader = TestClassCollector.createUsersClassLoader((JavaTestConfigurationBase)this.myConfiguration);
        try {
            ServiceLoader<?> serviceLoader = ServiceLoader.load(Class.forName("org.junit.platform.engine.TestEngine", false, loader), loader);
            for (Object engine : serviceLoader) {
                String engineClassName = engine.getClass().getName();
                if (!TestObject.isCustomJunit5TestEngineName(engineClassName)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean findCustomJunit5TestEngineUsingPsi(@NotNull GlobalSearchScope globalSearchScope, @NotNull Project project, @NotNull JavaPsiFacade psiFacade) {
        PsiClass testEngine;
        if (globalSearchScope == null) {
            TestObject.$$$reportNull$$$0(9);
        }
        if (project == null) {
            TestObject.$$$reportNull$$$0(10);
        }
        if (psiFacade == null) {
            TestObject.$$$reportNull$$$0(11);
        }
        if ((testEngine = psiFacade.findClass("org.junit.platform.engine.TestEngine", globalSearchScope)) == null) {
            return false;
        }
        return Stream.of(FilenameIndex.getFilesByName((Project)project, (String)"org.junit.platform.engine.TestEngine", (GlobalSearchScope)GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)globalSearchScope, (FileType[])new FileType[]{SPIFileType.INSTANCE}))).flatMap(f -> PsiTreeUtil.findChildrenOfType((PsiElement)f, SPIClassProviderReferenceElement.class).stream()).map(r -> r.resolve()).filter(e -> e instanceof PsiClass).map(e -> (PsiClass)e).filter(c -> TestObject.isCustomJunit5TestEngineName(c.getQualifiedName())).anyMatch(c -> InheritanceUtil.isInheritorOrSelf((PsiClass)c, (PsiClass)testEngine, (boolean)true));
    }

    private static boolean isCustomJunit5TestEngineName(@Nullable String engineImplClassName) {
        return !"org.junit.jupiter.engine.JupiterTestEngine".equals(engineImplClassName) && !"org.junit.vintage.engine.VintageTestEngine".equals(engineImplClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/TestObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSearchScope";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getForkMode";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/TestObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCustomJUnit5TestEngineUsingClassLoader";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findCustomJunit5TestEngineUsingPsi";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findCustomJUnit5TestEngineUsingClassLoader$4";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

