/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.TestClassCollector;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class TestDirectory
extends TestPackage {
    public TestDirectory(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    @Nullable
    public SourceScope getSourceScope() {
        String dirName = this.getConfiguration().getPersistentData().getDirName();
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)dirName));
        final Project project = this.getConfiguration().getProject();
        final GlobalSearchScope globalSearchScope = file == null ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)file, (boolean)true);
        return new SourceScope(){

            public GlobalSearchScope getGlobalSearchScope() {
                return globalSearchScope;
            }

            public Project getProject() {
                return project;
            }

            public GlobalSearchScope getLibrariesScope() {
                Module module = ((JavaRunConfigurationModule)TestDirectory.this.getConfiguration().getConfigurationModule()).getModule();
                return module != null ? GlobalSearchScope.moduleWithLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
            }

            public Module[] getModulesToCompile() {
                Collection<Module> validModules = TestDirectory.this.getConfiguration().getValidModules();
                return validModules.toArray(Module.EMPTY_ARRAY);
            }
        };
    }

    @Override
    @Nullable
    protected Path getRootPath() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.getConfiguration().getPersistentData().getDirName()));
        if (file == null) {
            return null;
        }
        Module dirModule = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.getConfiguration().getProject());
        if (dirModule == null) {
            return null;
        }
        return TestClassCollector.getRootPath((Module)dirModule, (boolean)true);
    }

    @Override
    protected boolean configureByModule(Module module) {
        return module != null;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
        String dirName = this.getConfiguration().getPersistentData().getDirName();
        if (dirName == null || dirName.isEmpty()) {
            throw new RuntimeConfigurationError("Directory is not specified");
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)dirName));
        if (file == null) {
            throw new RuntimeConfigurationWarning("Directory '" + dirName + "' is not found");
        }
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        if (module == null) {
            throw new RuntimeConfigurationError("Module to choose classpath from is not specified");
        }
    }

    @Override
    protected GlobalSearchScope filterScope(JUnitConfiguration.Data data) throws CantRunException {
        return GlobalSearchScope.allScope((Project)this.getConfiguration().getProject());
    }

    @Override
    protected String getPackageName(JUnitConfiguration.Data data) throws CantRunException {
        return "";
    }

    @Override
    protected void collectClassesRecursively(TestClassFilter classFilter, Condition<PsiClass> acceptClassCondition, Set<PsiClass> classes) throws CantRunException {
        TestDirectory.collectClassesRecursively(this.getDirectory(this.getConfiguration().getPersistentData()), acceptClassCondition, classes);
    }

    private static void collectClassesRecursively(PsiDirectory directory, Condition<PsiClass> acceptAsTest, Set<PsiClass> classes) {
        PsiFile[] files;
        PsiDirectory[] subDirectories;
        for (PsiDirectory subDirectory : subDirectories = (PsiDirectory[])ReadAction.compute(() -> directory.getSubdirectories())) {
            TestDirectory.collectClassesRecursively(subDirectory, acceptAsTest, classes);
        }
        for (PsiFile file : files = (PsiFile[])ReadAction.compute(() -> directory.getFiles())) {
            if (!(file instanceof PsiClassOwner)) continue;
            for (PsiClass aClass : (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)file).getClasses())) {
                TestDirectory.collectInnerClasses(aClass, acceptAsTest, classes);
            }
        }
    }

    @Override
    protected PsiPackage getPackage(JUnitConfiguration.Data data) throws CantRunException {
        PsiDirectory directory = this.getDirectory(data);
        return (PsiPackage)ReadAction.compute(() -> JavaDirectoryService.getInstance().getPackageInSources(directory));
    }

    private PsiDirectory getDirectory(JUnitConfiguration.Data data) throws CantRunException {
        String dirName = data.getDirName();
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)dirName));
        if (file == null) {
            throw new CantRunException("Directory '" + dirName + "' is not found");
        }
        PsiDirectory directory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getConfiguration().getProject()).findDirectory(file));
        if (directory == null) {
            throw new CantRunException("Directory '" + dirName + "' is not found");
        }
        return directory;
    }

    @Override
    public String suggestActionName() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        String dirName = data.getDirName();
        return dirName.isEmpty() ? ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]) : ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{StringUtil.getShortName((String)dirName, (char)'/')});
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return "directory".equals(configuration.getPersistentData().TEST_OBJECT) && testDir != null && Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)configuration.getPersistentData().getDirName()), (String)testDir.getVirtualFile().getPath());
    }
}

