/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.lang.xpath.xslt.quickfix.RenameVariableFix;
import org.intellij.lang.xpath.xslt.validation.DeclarationChecker;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltInspection;
import org.jetbrains.annotations.NotNull;

public class VariableShadowingInspection
extends XsltInspection {
    @NotNull
    public String getDisplayName() {
        if ("Variable Shadowing" == null) {
            VariableShadowingInspection.$$$reportNull$$$0(0);
        }
        return "Variable Shadowing";
    }

    @NotNull
    public String getShortName() {
        if ("XsltVariableShadowing" == null) {
            VariableShadowingInspection.$$$reportNull$$$0(1);
        }
        return "XsltVariableShadowing";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            VariableShadowingInspection.$$$reportNull$$$0(2);
        }
        if (!(holder.getFile() instanceof XmlFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                VariableShadowingInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                XmlTag shadowedVariable;
                XmlAttribute nameAttr = tag.getAttribute("name", null);
                if (nameAttr == null || PsiTreeUtil.hasErrorElements((PsiElement)nameAttr)) {
                    return;
                }
                if (XsltSupport.isVariableOrParam(tag) && (shadowedVariable = DeclarationChecker.getInstance((XmlFile)tag.getContainingFile()).getShadowedVariable(tag)) != null) {
                    String innerKind = XsltSupport.isParam(tag) ? "Parameter" : "Variable";
                    String outerKind = XsltSupport.isParam(shadowedVariable) ? "parameter" : "variable";
                    LocalQuickFix fix1 = new RenameVariableFix(tag, "local").createQuickFix(isOnTheFly);
                    LocalQuickFix fix2 = new RenameVariableFix(shadowedVariable, "outer").createQuickFix(isOnTheFly);
                    XmlAttribute name = tag.getAttribute("name");
                    assert (name != null);
                    PsiElement token = XsltSupport.getAttValueToken(name);
                    assert (token != null);
                    holder.registerProblem(token, innerKind + " '" + name.getValue() + "' shadows " + outerKind, AbstractFix.createFixes(fix1, fix2));
                }
            }
        };
        if (xmlElementVisitor == null) {
            VariableShadowingInspection.$$$reportNull$$$0(4);
        }
        return xmlElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/validation/inspections/VariableShadowingInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/validation/inspections/VariableShadowingInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

