/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class CreateTemplateFix
implements LocalQuickFix {
    private static final String DUMMY_NS = "urn:x__dummy__";
    private static final String DUMMY_TAG = "<dummy xmlns='urn:x__dummy__' />";
    private final XmlTag myTag;
    private final String myName;

    public CreateTemplateFix(XmlTag tag, String name) {
        this.myTag = tag;
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = "Create Template '" + this.myName + "'";
        if (string == null) {
            CreateTemplateFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Create Template" == null) {
            CreateTemplateFix.$$$reportNull$$$0(1);
        }
        return "Create Template";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlTag tag;
        if (project == null) {
            CreateTemplateFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            CreateTemplateFix.$$$reportNull$$$0(3);
        }
        if ((tag = XsltCodeInsightUtil.getTemplateTag((PsiElement)this.myTag, false)) == null) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        assert (parentTag != null);
        XmlTag templateTag = parentTag.createChildTag("template", "http://www.w3.org/1999/XSL/Transform", DUMMY_TAG, false);
        templateTag.setAttribute("name", this.myName);
        XmlTag[] arguments = this.myTag.findSubTags("with-param", "http://www.w3.org/1999/XSL/Transform");
        if (arguments.length > 0) {
            XmlTag dummy = templateTag.findFirstSubTag("dummy");
            for (XmlTag arg : arguments) {
                String argName = arg.getAttributeValue("name");
                if (argName == null) continue;
                XmlTag paramTag = parentTag.createChildTag("param", "http://www.w3.org/1999/XSL/Transform", null, false);
                paramTag.setAttribute("name", argName);
                templateTag.addBefore((PsiElement)paramTag, (PsiElement)dummy);
            }
        }
        XmlTag newTemplateTag = (XmlTag)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)templateTag);
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, this.myTag.getContainingFile().getVirtualFile(), newTemplateTag.getTextRange().getStartOffset());
        FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/CreateTemplateFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/CreateTemplateFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

