/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.StringSearchModelInterpolator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.SingleResponseValueSource;
import org.codehaus.plexus.interpolation.ValueSource;

@Component(role=ModelInterpolator.class, hint="ide")
public class CustomMaven3ModelInterpolator2
extends StringSearchModelInterpolator {
    public static final String SHA1_PROPERTY = "sha1";
    public static final String CHANGELIST_PROPERTY = "changelist";
    public static final String REVISION_PROPERTY = "revision";
    private String localRepository;

    public void interpolateObject(Object obj, Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        super.interpolateObject(obj, model, projectDir, config, problems);
    }

    protected List<ValueSource> createValueSources(Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        List res = super.createValueSources(model, projectDir, config, problems);
        if (this.localRepository != null) {
            res.add(new SingleResponseValueSource("settings.localRepository", (Object)this.localRepository));
        }
        int firstMapIndex = ContainerUtil.indexOf((List)res, (Condition)new Condition<ValueSource>(){

            public boolean value(ValueSource source) {
                return source instanceof MapBasedValueSource;
            }
        });
        HashMap<String, String> rightOrderProperties = new HashMap<String, String>(3);
        if (config.getSystemProperties().containsKey(REVISION_PROPERTY)) {
            rightOrderProperties.put(REVISION_PROPERTY, config.getSystemProperties().getProperty(REVISION_PROPERTY));
        }
        if (config.getSystemProperties().containsKey(CHANGELIST_PROPERTY)) {
            rightOrderProperties.put(CHANGELIST_PROPERTY, config.getSystemProperties().getProperty(CHANGELIST_PROPERTY));
        }
        if (config.getSystemProperties().containsKey(SHA1_PROPERTY)) {
            rightOrderProperties.put(SHA1_PROPERTY, config.getSystemProperties().getProperty(SHA1_PROPERTY));
        }
        res.add(firstMapIndex + 1, new MapBasedValueSource(rightOrderProperties));
        return res;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }
}

