/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collections;
import java.util.Set;

public class JavaFxApplicationClassBrowser
extends ClassBrowser {
    private final Artifact myArtifact;

    public JavaFxApplicationClassBrowser(Project project, Artifact artifact) {
        this(project, artifact, "Choose Application Class");
    }

    public JavaFxApplicationClassBrowser(Project project, Artifact artifact, String title) {
        super(project, title);
        this.myArtifact = artifact;
    }

    protected ClassFilter.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
        return new ClassFilter.ClassFilterWithScope(){

            public GlobalSearchScope getScope() {
                return GlobalSearchScope.projectScope((Project)JavaFxApplicationClassBrowser.this.getProject());
            }

            public boolean isAccepted(PsiClass aClass) {
                return InheritanceUtil.isInheritor((PsiClass)aClass, (String)JavaFxApplicationClassBrowser.this.getApplicationClass());
            }
        };
    }

    protected String getApplicationClass() {
        return "javafx.application.Application";
    }

    protected PsiClass findClass(String className) {
        Set modules = (Set)ReadAction.compute(() -> ArtifactUtil.getModulesIncludedInArtifacts(Collections.singletonList(this.myArtifact), (Project)this.getProject()));
        for (Module module : modules) {
            PsiClass aClass = JavaExecutionUtil.findMainClass((Project)this.getProject(), (String)className, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module));
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }
}

