/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;

public class JavaFxStaticPropertyReference
extends JavaFxPropertyReference<XmlAttribute> {
    private final String myPropertyName;
    private final PsiMethod myStaticMethod;

    public JavaFxStaticPropertyReference(@NotNull XmlAttribute xmlAttribute, @Nullable PsiClass psiClass, @NotNull String propertyName) {
        if (xmlAttribute == null) {
            JavaFxStaticPropertyReference.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            JavaFxStaticPropertyReference.$$$reportNull$$$0(1);
        }
        super(xmlAttribute, psiClass);
        this.myPropertyName = propertyName;
        this.myStaticMethod = JavaFxPsiUtil.findStaticPropertySetter(propertyName, psiClass);
    }

    @Nullable
    public PsiElement resolve() {
        return this.myStaticMethod;
    }

    @Override
    @Nullable
    public PsiMethod getGetter() {
        return null;
    }

    @Override
    @Nullable
    public PsiMethod getSetter() {
        return null;
    }

    @Override
    @Nullable
    public PsiField getField() {
        return null;
    }

    @Override
    @Nullable
    public PsiMethod getObservableGetter() {
        return null;
    }

    @Override
    @Nullable
    public PsiMethod getStaticSetter() {
        return this.myStaticMethod;
    }

    @Override
    public PsiType getType() {
        PsiParameter[] parameters;
        if (this.myStaticMethod != null && (parameters = this.myStaticMethod.getParameterList().getParameters()).length == 2) {
            return parameters[1].getType();
        }
        return null;
    }

    @Override
    public String getPropertyName() {
        return this.myPropertyName;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JavaFxStaticPropertyReference.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String newPropertyName = JavaFxPsiUtil.getPropertyName(newElementName, true);
        return super.handleElementRename(newPropertyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttribute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

