/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFxSettings;

public class JavaFxSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final JavaFxSettings mySettings;
    private JavaFxConfigurablePanel myPanel;

    public JavaFxSettingsConfigurable(JavaFxSettings settings) {
        this.mySettings = settings;
    }

    @Nls
    public String getDisplayName() {
        return "JavaFX";
    }

    @Nullable
    public String getHelpTopic() {
        return "preferences.JavaFX";
    }

    @Nullable
    public JComponent createComponent() {
        this.myPanel = new JavaFxConfigurablePanel();
        return this.myPanel.myWholePanel;
    }

    public boolean isModified() {
        return this.myPanel.isModified(this.mySettings);
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply(this.mySettings);
    }

    public void reset() {
        this.myPanel.reset(this.mySettings);
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            JavaFxSettingsConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static FileChooserDescriptor createSceneBuilderDescriptor() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        descriptor.setTitle("SceneBuilder Configuration");
        descriptor.setDescription("Select path to SceneBuilder executable");
        return descriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JavaFxSettingsConfigurable", "getId"));
    }

    public static class JavaFxConfigurablePanel {
        private TextFieldWithBrowseButton myPathField;
        private JPanel myWholePanel;

        public JavaFxConfigurablePanel() {
            this.$$$setupUI$$$();
            FileChooserDescriptor descriptor = JavaFxSettingsConfigurable.createSceneBuilderDescriptor();
            this.myPathField.addBrowseFolderListener(descriptor.getTitle(), descriptor.getDescription(), null, descriptor);
        }

        private void reset(JavaFxSettings settings) {
            String pathToSceneBuilder = settings.getPathToSceneBuilder();
            if (pathToSceneBuilder != null) {
                this.myPathField.setText(FileUtil.toSystemDependentName((String)pathToSceneBuilder));
            }
        }

        private void apply(JavaFxSettings settings) {
            settings.setPathToSceneBuilder(FileUtil.toSystemIndependentName((String)this.myPathField.getText().trim()));
        }

        private boolean isModified(JavaFxSettings settings) {
            String pathToSceneBuilder = settings.getPathToSceneBuilder();
            return !Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)this.myPathField.getText().trim()), (String)(pathToSceneBuilder != null ? pathToSceneBuilder.trim() : null));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            jLabel.setText("Path to SceneBuilder:");
            jLabel.setDisplayedMnemonic('P');
            jLabel.setDisplayedMnemonicIndex(0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jLabel, gridBagConstraints);
            JPanel jPanel2 = new JPanel();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 3;
            jPanel.add((Component)jPanel2, gridBagConstraints2);
            this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            jPanel.add((Component)textFieldWithBrowseButton, gridBagConstraints3);
            jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }
}

