/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.xml.ui.Committable;
import java.util.HashSet;
import java.util.Set;

public class UndoHelper {
    private boolean myShowing;
    private final Set<Document> myCurrentDocuments = new HashSet<Document>();
    private boolean myDirty;
    private final DocumentListener myDocumentAdapter = new DocumentListener(){

        public void documentChanged(DocumentEvent e) {
            if (UndoHelper.this.myShowing) {
                UndoHelper.this.myDirty = true;
            }
        }
    };

    public UndoHelper(Project project, final Committable committable) {
        final PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        CommandProcessor.getInstance().addCommandListener(new CommandListener(){

            public void commandStarted(CommandEvent event) {
                this.undoTransparentActionStarted();
            }

            public void undoTransparentActionStarted() {
                UndoHelper.this.myDirty = false;
            }

            public void undoTransparentActionFinished() {
                if (UndoHelper.this.myDirty) {
                    psiDocumentManager.commitAllDocuments();
                    committable.reset();
                }
            }

            public void commandFinished(CommandEvent event) {
                this.undoTransparentActionFinished();
            }
        }, (Disposable)committable);
    }

    public final void startListeningDocuments() {
        for (Document document : this.myCurrentDocuments) {
            document.addDocumentListener(this.myDocumentAdapter);
        }
    }

    public final void stopListeningDocuments() {
        for (Document document : this.myCurrentDocuments) {
            document.removeDocumentListener(this.myDocumentAdapter);
        }
    }

    public final void setShowing(boolean showing) {
        this.myShowing = showing;
    }

    public boolean isShowing() {
        return this.myShowing;
    }

    public final void addWatchedDocument(Document document) {
        this.stopListeningDocuments();
        this.myCurrentDocuments.add(document);
        this.startListeningDocuments();
    }

    public final void removeWatchedDocument(Document document) {
        this.stopListeningDocuments();
        this.myCurrentDocuments.remove(document);
        this.startListeningDocuments();
    }

    public final Document[] getDocuments() {
        return this.myCurrentDocuments.toArray(Document.EMPTY_ARRAY);
    }
}

