/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class JavaCodeInsightTestFixtureImpl
extends CodeInsightTestFixtureImpl
implements JavaCodeInsightTestFixture {
    public JavaCodeInsightTestFixtureImpl(IdeaProjectTestFixture projectFixture, TempDirTestFixture tempDirFixture) {
        super(projectFixture, tempDirFixture);
    }

    @Override
    public JavaPsiFacadeEx getJavaFacade() {
        this.assertInitialized();
        return JavaPsiFacadeEx.getInstanceEx((Project)this.getProject());
    }

    @Override
    public PsiClass addClass(@NotNull @NonNls String classText) {
        if (classText == null) {
            JavaCodeInsightTestFixtureImpl.$$$reportNull$$$0(0);
        }
        this.assertInitialized();
        String rootPath = this.getTempDirPath();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.getModule());
        if (rootManager != null) {
            Object[] allSourceRoots = rootManager.getSourceRoots(true);
            Object[] productionSourceRoots = rootManager.getSourceRoots(false);
            VirtualFile rootVirtualFile = this.getTempDirFixture().getFile("");
            if (!ArrayUtil.contains((Object)rootVirtualFile, (Object[])allSourceRoots) && !ArrayUtil.isEmpty((Object[])productionSourceRoots)) {
                rootPath = productionSourceRoots[0].getPath();
            }
        }
        PsiClass psiClass = this.addClass(rootPath, classText);
        VirtualFile file = psiClass.getContainingFile().getVirtualFile();
        this.allowTreeAccessForFile(file);
        return psiClass;
    }

    private PsiClass addClass(@NonNls String rootPath, @NotNull @NonNls String classText) {
        if (classText == null) {
            JavaCodeInsightTestFixtureImpl.$$$reportNull$$$0(1);
        }
        String qName = (String)ReadAction.compute(() -> {
            if (classText == null) {
                JavaCodeInsightTestFixtureImpl.$$$reportNull$$$0(6);
            }
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.getProject());
            PsiJavaFile javaFile = (PsiJavaFile)factory.createFileFromText("a.java", (FileType)JavaFileType.INSTANCE, (CharSequence)classText);
            return javaFile.getClasses()[0].getQualifiedName();
        });
        assert (qName != null);
        PsiFile psiFile = this.addFileToProject(rootPath, qName.replace('.', '/') + ".java", classText);
        return (PsiClass)ReadAction.compute(() -> ((PsiJavaFile)psiFile).getClasses()[0]);
    }

    @Override
    @NotNull
    public PsiClass findClass(@NotNull @NonNls String name) {
        if (name == null) {
            JavaCodeInsightTestFixtureImpl.$$$reportNull$$$0(2);
        }
        PsiClass aClass = this.getJavaFacade().findClass(name, GlobalSearchScope.allScope((Project)this.getProject()));
        Assert.assertNotNull((String)("Class " + name + " not found"), (Object)aClass);
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            JavaCodeInsightTestFixtureImpl.$$$reportNull$$$0(3);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiPackage findPackage(@NotNull @NonNls String name) {
        if (name == null) {
            JavaCodeInsightTestFixtureImpl.$$$reportNull$$$0(4);
        }
        PsiPackage aPackage = this.getJavaFacade().findPackage(name);
        Assert.assertNotNull((String)("Package " + name + " not found"), (Object)aPackage);
        PsiPackage psiPackage = aPackage;
        if (psiPackage == null) {
            JavaCodeInsightTestFixtureImpl.$$$reportNull$$$0(5);
        }
        return psiPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classText";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addClass$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

