/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.idea.Bombed;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.SkipInHeadlessEnvironment;
import com.intellij.testFramework.SkipSlowTestLocally;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;

public class TestFrameworkUtil {
    public static final boolean SKIP_HEADLESS = GraphicsEnvironment.isHeadless();
    public static final boolean SKIP_SLOW = Boolean.getBoolean("skip.slow.tests.locally");

    private static Date raidDate(Bombed bombed) {
        Calendar instance = Calendar.getInstance();
        instance.set(1, bombed.year());
        instance.set(2, bombed.month());
        instance.set(5, bombed.day());
        instance.set(11, bombed.time());
        instance.set(12, 0);
        return instance.getTime();
    }

    public static boolean bombExplodes(Bombed bombedAnnotation) {
        Date now = new Date();
        return now.after(TestFrameworkUtil.raidDate(bombedAnnotation));
    }

    public static boolean canRunTest(@NotNull Class testCaseClass) {
        if (testCaseClass == null) {
            TestFrameworkUtil.$$$reportNull$$$0(0);
        }
        if (!SKIP_SLOW && !SKIP_HEADLESS) {
            return true;
        }
        for (Class clazz = testCaseClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (SKIP_HEADLESS && clazz.getAnnotation(SkipInHeadlessEnvironment.class) != null) {
                System.out.println("Class '" + testCaseClass.getName() + "' is skipped because it requires working UI environment");
                return false;
            }
            if (!SKIP_SLOW || clazz.getAnnotation(SkipSlowTestLocally.class) == null) continue;
            System.out.println("Class '" + testCaseClass.getName() + "' is skipped because it is dog slow");
            return false;
        }
        return true;
    }

    public static boolean isJUnit4TestClass(@NotNull Class aClass) {
        int modifiers;
        if (aClass == null) {
            TestFrameworkUtil.$$$reportNull$$$0(1);
        }
        if (((modifiers = aClass.getModifiers()) & 0x400) != 0) {
            return false;
        }
        if ((modifiers & 1) == 0) {
            return false;
        }
        if (aClass.getAnnotation(RunWith.class) != null) {
            return true;
        }
        for (Method method : aClass.getMethods()) {
            if (method.getAnnotation(Test.class) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isPerformanceTest(@Nullable String testName, @Nullable String className) {
        return testName != null && StringUtil.containsIgnoreCase((String)testName, (String)"performance") || className != null && StringUtil.containsIgnoreCase((String)className, (String)"performance");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestFrameworkUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRunTest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit4TestClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

