/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.LightCodeInsightTestCase;
import java.io.IOException;

public abstract class EditorActionTestCase
extends LightCodeInsightTestCase {
    protected abstract String getActionId();

    protected void doTextTest(String fileName, String textBefore, String textAfter) throws IOException {
        this.doTextTest(fileName, textBefore, textAfter, false);
    }

    protected void doTextTest(String fileName, String textBefore, String textAfter, boolean ignoreTrailingSpaces) throws IOException {
        EditorActionTestCase.configureFromFileText((String)fileName, (String)textBefore);
        this.invokeAction();
        PsiDocumentManager.getInstance((Project)EditorActionTestCase.getProject()).commitAllDocuments();
        EditorActionTestCase.assertEquals((String)"Reparse error!", (String)myEditor.getDocument().getText(), (String)myFile.getText());
        this.checkResultByText(null, textAfter, ignoreTrailingSpaces);
    }

    protected void doFileTest(String filePathBefore, String filePathAfter) throws Exception {
        this.doFileTest(filePathBefore, filePathAfter, false);
    }

    protected void doFileTest(String filePathBefore, String filePathAfter, boolean ignoreTrailingSpaces) {
        this.configureByFile(filePathBefore);
        this.invokeAction();
        this.checkResultByFile(null, filePathAfter, ignoreTrailingSpaces);
    }

    private void invokeAction() {
        String actionId = this.getActionId();
        AnAction action = ActionManager.getInstance().getAction(actionId);
        EditorActionTestCase.assertNotNull((String)("Can find registered action with id=" + actionId), (Object)action);
        action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)DataManager.getInstance().getDataContext()));
    }
}

