/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.openapi.diagnostic.Logger;

public class SynchronizationBasedSemaphore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.Semaphore");
    private int mySemaphore = 0;

    public synchronized void down() {
        ++this.mySemaphore;
        if (this.mySemaphore == 0) {
            this.notifyAll();
        }
    }

    public synchronized void up() {
        --this.mySemaphore;
        if (this.mySemaphore == 0) {
            this.notifyAll();
        }
    }

    public synchronized void waitFor() {
        try {
            while (this.mySemaphore > 0) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            LOG.debug((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public synchronized boolean waitFor(long timeout) {
        try {
            if (this.mySemaphore == 0) {
                return true;
            }
            long startTime = System.currentTimeMillis();
            long waitTime = timeout;
            while (this.mySemaphore > 0) {
                this.wait(waitTime);
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed >= timeout) break;
                waitTime = timeout - elapsed;
            }
            return this.mySemaphore == 0;
        }
        catch (InterruptedException e) {
            LOG.debug((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

