/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public abstract class TestClassesFilter {
    public static final TestClassesFilter ALL_CLASSES = new TestClassesFilter(){

        @Override
        public boolean matches(String className, String moduleName) {
            return true;
        }

        public String toString() {
            return "ALL_CLASSES";
        }
    };

    public abstract boolean matches(String var1, @Nullable String var2);

    public boolean matches(String className) {
        return this.matches(className, null);
    }

    protected static ArrayList<Pattern> compilePatterns(Collection<String> filterList) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String aFilter : filterList) {
            String filter = aFilter.trim();
            if (filter.length() == 0) continue;
            filter = filter.replaceAll("\\*", ".\\*");
            Pattern pattern = Pattern.compile(filter);
            patterns.add(pattern);
        }
        return patterns;
    }

    protected static boolean matchesAnyPattern(Collection<Pattern> patterns, String className) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public static class And
    extends TestClassesFilter {
        private final TestClassesFilter first;
        private final TestClassesFilter second;

        public And(TestClassesFilter first, TestClassesFilter second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean matches(String className, @Nullable String moduleName) {
            return this.first.matches(className, moduleName) && this.second.matches(className, moduleName);
        }

        public String toString() {
            return "AndTestClassesFilter{first: " + this.first.toString() + ",second: " + this.second.toString() + '}';
        }
    }
}

