/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000b*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\n\u001a\u0012\u0010\u000f\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\n\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013\u001a2\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u0007*\u0002H\u00152\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0017H\u0086\b\u00a2\u0006\u0002\u0010\u0018\u001a8\u0010\u0019\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u0007*\u0002H\u00152\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001aH\u0086\b\u00a2\u0006\u0002\u0010\u001b\u001a\u001c\u0010\u001c\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011\u001a\u0012\u0010\u001e\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001f"}, d2={"typeArgumentsCount", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getTypeArgumentsCount", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)I", "copyTypeArgumentsFrom", "", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "source", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "other", "getTypeArgument", "typeParameterDescriptor", "getTypeArgumentOrDefault", "getValueArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "mapValueParameters", "T", "transform", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "mapValueParametersIndexed", "Lkotlin/Function2;", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "putValueArgument", "valueArgument", "removeValueArgument", "ir.tree"})
public final class IrMemberAccessExpressionKt {
    @Nullable
    public static final KotlinType getTypeArgument(@NotNull IrMemberAccessExpression $receiver, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(typeParameterDescriptor, "typeParameterDescriptor");
        return $receiver.getTypeArgument(typeParameterDescriptor.getIndex());
    }

    /*
     * WARNING - void declaration
     */
    public static final void copyTypeArgumentsFrom(@NotNull IrMemberAccessExpression $receiver, @NotNull IrMemberAccessExpression other) {
        int n;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        int n2 = n = $receiver.getTypeArgumentsCount() == other.getTypeArgumentsCount() ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Mismatching type arguments: " + $receiver.getTypeArgumentsCount() + " vs " + other.getTypeArgumentsCount() + ' ';
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = 0;
        int n3 = $receiver.getTypeArgumentsCount();
        while (n < n3) {
            void i;
            $receiver.putTypeArgument((int)i, other.getTypeArgument((int)i));
            ++i;
        }
    }

    public static final void copyTypeArgumentsFrom(@NotNull IrMemberAccessExpression $receiver, @Nullable Map<TypeParameterDescriptor, ? extends KotlinType> source) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (source == null) {
            return;
        }
        Map<TypeParameterDescriptor, ? extends KotlinType> map2 = source;
        Iterator<Map.Entry<TypeParameterDescriptor, ? extends KotlinType>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            Map.Entry<TypeParameterDescriptor, ? extends KotlinType> entry;
            Map.Entry<TypeParameterDescriptor, ? extends KotlinType> entry2 = entry = iterator2.next();
            TypeParameterDescriptor typeParameter = entry2.getKey();
            entry2 = entry;
            KotlinType typeArgument = entry2.getValue();
            int index2 = typeParameter.getIndex();
            boolean bl2 = bl = index2 < $receiver.getTypeArgumentsCount();
            if (_Assertions.ENABLED && !bl) {
                String string = "Index out of range for type parameter " + typeParameter + "; " + "containingDeclaration: " + typeParameter.getContainingDeclaration() + "; " + "callee: " + $receiver.getDescriptor();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            $receiver.putTypeArgument(index2, typeArgument);
        }
    }

    public static final int getTypeArgumentsCount(@NotNull CallableDescriptor $receiver) {
        int n;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CallableDescriptor callableDescriptor = $receiver;
        if (callableDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "correspondingProperty");
            n = propertyDescriptor.getTypeParameters().size();
        } else {
            n = $receiver.getTypeParameters().size();
        }
        return n;
    }

    @NotNull
    public static final KotlinType getTypeArgumentOrDefault(@NotNull IrMemberAccessExpression $receiver, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(typeParameterDescriptor, "typeParameterDescriptor");
        KotlinType kotlinType = IrMemberAccessExpressionKt.getTypeArgument($receiver, typeParameterDescriptor);
        if (kotlinType == null) {
            SimpleType simpleType2 = typeParameterDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "typeParameterDescriptor.defaultType");
            kotlinType = simpleType2;
        }
        return kotlinType;
    }

    @Nullable
    public static final IrExpression getValueArgument(@NotNull IrMemberAccessExpression $receiver, @NotNull ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptor, "valueParameterDescriptor");
        return $receiver.getValueArgument(valueParameterDescriptor.getIndex());
    }

    public static final void putValueArgument(@NotNull IrMemberAccessExpression $receiver, @NotNull ValueParameterDescriptor valueParameterDescriptor, @Nullable IrExpression valueArgument) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptor, "valueParameterDescriptor");
        $receiver.putValueArgument(valueParameterDescriptor.getIndex(), valueArgument);
    }

    public static final void removeValueArgument(@NotNull IrMemberAccessExpression $receiver, @NotNull ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptor, "valueParameterDescriptor");
        $receiver.removeValueArgument(valueParameterDescriptor.getIndex());
    }

    @NotNull
    public static final <T extends IrMemberAccessExpression> T mapValueParameters(@NotNull T $receiver, @NotNull Function1<? super ValueParameterDescriptor, ? extends IrExpression> transform) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        List<ValueParameterDescriptor> list2 = $receiver.getDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.valueParameters");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            int n = it.getIndex();
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "it");
            $receiver.putValueArgument(n, transform.invoke(valueParameterDescriptor));
        }
        return $receiver;
    }

    @NotNull
    public static final <T extends IrMemberAccessExpression> T mapValueParametersIndexed(@NotNull T $receiver, @NotNull Function2<? super Integer, ? super ValueParameterDescriptor, ? extends IrExpression> transform) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        List<ValueParameterDescriptor> list2 = $receiver.getDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.valueParameters");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            int n = it.getIndex();
            Integer n2 = it.getIndex();
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "it");
            $receiver.putValueArgument(n, transform.invoke(n2, valueParameterDescriptor));
        }
        return $receiver;
    }
}

