/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaVersion
implements Comparable<JavaVersion> {
    public final int feature;
    public final int minor;
    public final int update;
    public final int build;
    public final boolean ea;
    private static JavaVersion current;

    private JavaVersion(int feature, int minor, int update, int build2, boolean ea) {
        this.feature = feature;
        this.minor = minor;
        this.update = update;
        this.build = build2;
        this.ea = ea;
    }

    @Override
    public int compareTo(@NotNull JavaVersion o) {
        int diff;
        if (o == null) {
            JavaVersion.$$$reportNull$$$0(0);
        }
        if ((diff = this.feature - o.feature) != 0) {
            return diff;
        }
        diff = this.minor - o.minor;
        if (diff != 0) {
            return diff;
        }
        diff = this.update - o.update;
        if (diff != 0) {
            return diff;
        }
        diff = this.build - o.build;
        if (diff != 0) {
            return diff;
        }
        return (this.ea ? 0 : 1) - (o.ea ? 0 : 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaVersion)) {
            return false;
        }
        JavaVersion other = (JavaVersion)o;
        return this.feature == other.feature && this.minor == other.minor && this.update == other.update && this.build == other.build && this.ea == other.ea;
    }

    public int hashCode() {
        int hash = this.feature;
        hash = 31 * hash + this.minor;
        hash = 31 * hash + this.update;
        hash = 31 * hash + this.build;
        hash = 31 * hash + (this.ea ? 1231 : 1237);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.feature > 8) {
            sb.append(this.feature);
            if (this.minor > 0 || this.update > 0) {
                sb.append('.').append(this.minor);
            }
            if (this.update > 0) {
                sb.append('.').append(this.update);
            }
            if (this.ea) {
                sb.append("-ea");
            }
            if (this.build > 0) {
                sb.append('+').append(this.build);
            }
        } else {
            sb.append("1.").append(this.feature);
            if (this.minor > 0 || this.update > 0 || this.ea || this.build > 0) {
                sb.append('.').append(this.minor);
            }
            if (this.update > 0) {
                sb.append('_').append(this.update);
            }
            if (this.ea) {
                sb.append("-ea");
            }
            if (this.build > 0) {
                sb.append("-b").append(this.build);
            }
        }
        return sb.toString();
    }

    @NotNull
    public static JavaVersion compose(int feature, int minor, int update, int build2, boolean ea) throws IllegalArgumentException {
        if (feature < 0) {
            throw new IllegalArgumentException();
        }
        if (minor < 0) {
            throw new IllegalArgumentException();
        }
        if (update < 0) {
            throw new IllegalArgumentException();
        }
        if (build2 < 0) {
            throw new IllegalArgumentException();
        }
        JavaVersion javaVersion = new JavaVersion(feature, minor, update, build2, ea);
        if (javaVersion == null) {
            JavaVersion.$$$reportNull$$$0(1);
        }
        return javaVersion;
    }

    @NotNull
    public static JavaVersion compose(int feature) {
        JavaVersion javaVersion = JavaVersion.compose(feature, 0, 0, 0, false);
        if (javaVersion == null) {
            JavaVersion.$$$reportNull$$$0(2);
        }
        return javaVersion;
    }

    @NotNull
    public static JavaVersion current() {
        if (current == null) {
            JavaVersion fallback = JavaVersion.parse(System.getProperty("java.version"));
            JavaVersion rt = JavaVersion.rtVersion();
            if (rt == null) {
                try {
                    rt = JavaVersion.parse(System.getProperty("java.runtime.version"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            current = rt != null && rt.feature == fallback.feature && rt.minor == fallback.minor ? rt : fallback;
        }
        JavaVersion javaVersion = current;
        if (javaVersion == null) {
            JavaVersion.$$$reportNull$$$0(3);
        }
        return javaVersion;
    }

    @Nullable
    private static JavaVersion rtVersion() {
        try {
            Object version = Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]);
            int major = (Integer)version.getClass().getMethod("major", new Class[0]).invoke(version, new Object[0]);
            int minor = (Integer)version.getClass().getMethod("minor", new Class[0]).invoke(version, new Object[0]);
            int security = (Integer)version.getClass().getMethod("security", new Class[0]).invoke(version, new Object[0]);
            Object buildOpt = version.getClass().getMethod("build", new Class[0]).invoke(version, new Object[0]);
            int build2 = (Integer)buildOpt.getClass().getMethod("orElse", Object.class).invoke(buildOpt, 0);
            Object preOpt = version.getClass().getMethod("pre", new Class[0]).invoke(version, new Object[0]);
            boolean ea = (Boolean)preOpt.getClass().getMethod("isPresent", new Class[0]).invoke(preOpt, new Object[0]);
            return new JavaVersion(major, minor, security, build2, ea);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @NotNull
    public static JavaVersion parse(@NotNull String versionString) throws IllegalArgumentException {
        block22: {
            int p;
            String str;
            if (versionString == null) {
                JavaVersion.$$$reportNull$$$0(4);
            }
            if ((str = versionString.trim()).contains("Runtime Environment") && (p = str.indexOf("(build ")) > 0) {
                str = str.substring(p);
            }
            ArrayList separators = new ArrayList();
            ArrayList<String> numbers = new ArrayList<String>();
            int length = str.length();
            int p2 = 0;
            boolean number = false;
            while (p2 < length) {
                int start = p2;
                while (p2 < length && Character.isDigit(str.charAt(p2)) == number) {
                    ++p2;
                }
                String part = str.substring(start, p2);
                (number ? numbers : separators).add(part);
                number = !number;
            }
            if (!numbers.isEmpty() && !separators.isEmpty()) {
                JavaVersion javaVersion;
                block23: {
                    boolean ea;
                    int build2;
                    int update;
                    int minor;
                    int feature;
                    block20: {
                        JavaVersion javaVersion2;
                        block21: {
                            feature = Integer.parseInt((String)numbers.get(0));
                            minor = 0;
                            update = 0;
                            build2 = 0;
                            ea = false;
                            if (feature < 5 || feature >= 25) break block20;
                            for (p2 = 1; p2 < separators.size() && ".".equals(separators.get(p2)); ++p2) {
                            }
                            if (p2 > 1 && numbers.size() > 2) {
                                minor = Integer.parseInt((String)numbers.get(1));
                                update = Integer.parseInt((String)numbers.get(2));
                            }
                            if (p2 < separators.size()) {
                                String s = (String)separators.get(p2);
                                if (StringUtil.startsWithChar(s, '-')) {
                                    boolean bl = ea = JavaVersion.startsWithWord(s, "-ea") || JavaVersion.startsWithWord(s, "-internal");
                                    if (p2 < numbers.size() && StringUtil.endsWithChar(s, '+')) {
                                        build2 = Integer.parseInt((String)numbers.get(p2));
                                    }
                                    ++p2;
                                }
                                if (build2 == 0 && p2 < separators.size() && p2 < numbers.size() && "+".equals(separators.get(p2))) {
                                    build2 = Integer.parseInt((String)numbers.get(p2));
                                }
                            }
                            if ((javaVersion2 = new JavaVersion(feature, minor, update, build2, ea)) != null) break block21;
                            JavaVersion.$$$reportNull$$$0(5);
                        }
                        return javaVersion2;
                    }
                    try {
                        if (feature != 1 || numbers.size() <= 1 || separators.size() <= 1 || !".".equals(separators.get(1)) || (feature = Integer.parseInt((String)numbers.get(1))) > 25) break block22;
                        if (numbers.size() > 2 && separators.size() > 2 && ".".equals(separators.get(2))) {
                            minor = Integer.parseInt((String)numbers.get(2));
                            if (numbers.size() > 3 && separators.size() > 3 && "_".equals(separators.get(3))) {
                                update = Integer.parseInt((String)numbers.get(3));
                                if (separators.size() > 4) {
                                    String s = (String)separators.get(4);
                                    if (StringUtil.startsWithChar(s, '-')) {
                                        ea = JavaVersion.startsWithWord(s, "-ea") || JavaVersion.startsWithWord(s, "-internal");
                                    }
                                    for (p2 = 4; p2 < separators.size() && !((String)separators.get(p2)).endsWith("-b"); ++p2) {
                                    }
                                    if (p2 < numbers.size()) {
                                        build2 = Integer.parseInt((String)numbers.get(p2));
                                    }
                                }
                            }
                        }
                        if ((javaVersion = new JavaVersion(feature, minor, update, build2, ea)) != null) break block23;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    JavaVersion.$$$reportNull$$$0(6);
                }
                return javaVersion;
            }
        }
        throw new IllegalArgumentException(versionString);
    }

    private static boolean startsWithWord(String s, String word) {
        return s.startsWith(word) && (s.length() == word.length() || !Character.isLetterOrDigit(s.charAt(word.length())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/JavaVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/JavaVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "compose";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "current";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

