/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private final Project myProject;
    private final PsiDocumentManagerBase myPsiDocManager;
    private final ReferenceQueue<SmartPsiElementPointerImpl> myQueue = new ReferenceQueue();
    private final ConcurrentMap<VirtualFile, SmartPointerTracker> myTrackerMap = ContainerUtil.newConcurrentMap();
    private static final Key<Reference<SmartPsiElementPointerImpl>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        LowMemoryWatcher.register(() -> this.processQueue(), project);
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(0);
        }
        this.processQueue();
        SmartPointerTracker pointers = this.getTracker(file2);
        if (pointers != null) {
            pointers.fastenBelts();
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(2);
        }
        return smartPsiElementPointer;
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(3);
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile, false);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(4);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile, boolean forInjected) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(5);
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            if (containingFile != null) {
                PsiUtilCore.ensureValid(containingFile);
            }
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        this.processQueue();
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (!(pointer == null || pointer.getElementInfo() instanceof SelfElementInfo && ((SelfElementInfo)pointer.getElementInfo()).isForInjected() != forInjected || pointer.incrementAndGetReferenceCount(1) <= 0)) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                SmartPointerManagerImpl.$$$reportNull$$$0(6);
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPsiElementPointerImpl<E>>(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(7);
        }
        return smartPsiElementPointerImpl;
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        Reference<SmartPsiElementPointerImpl> data;
        SmartPsiElementPointerImpl cachedPointer;
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(8);
        }
        if ((cachedPointer = SoftReference.dereference(data = element.getUserData(CACHED_SMART_POINTER_KEY))) != null && ((cachedElement = cachedPointer.getElement()) == null || cachedElement != element)) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(9);
        }
        if (range == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(10);
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file2, range, false);
        if (smartPsiFileRange == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(11);
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range, boolean forInjected) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(12);
        }
        if (range == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(13);
        }
        PsiUtilCore.ensureValid(file2);
        this.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file2, ProperTextRange.create(range), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(14);
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        SmartPointerTracker pointers;
        SmartPointerElementInfo info;
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(15);
        }
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(16);
        }
        if (!((info = pointer.getElementInfo()) instanceof SelfElementInfo)) {
            return;
        }
        SmartPointerTracker.PointerReference reference = new SmartPointerTracker.PointerReference(pointer, containingFile, this.myTrackerMap, this.myQueue);
        while (!(pointers = this.myTrackerMap.computeIfAbsent(containingFile, __ -> new SmartPointerTracker())).addReference(reference, pointer)) {
        }
    }

    @Override
    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(17);
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        PsiFile containingFile = pointer.getContainingFile();
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == -1) {
            LOG.error("Double smart pointer removal: " + pointer);
            return;
        }
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            if (containingFile == null) {
                return;
            }
            assert (containingFile.getProject() == this.myProject) : "Project mismatch: expected " + this.myProject + ", got " + containingFile.getProject();
            VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
            SmartPointerTracker pointers = this.getTracker(vFile);
            SmartPointerTracker.PointerReference reference = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (pointers != null && reference != null) {
                pointers.removeReference(reference, this.myTrackerMap);
            }
        }
    }

    @Nullable
    SmartPointerTracker getTracker(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(18);
        }
        return (SmartPointerTracker)this.myTrackerMap.get(containingFile);
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        VirtualFile file2;
        SmartPointerTracker pointers;
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(19);
        }
        return (pointers = this.getTracker(file2 = containingFile.getViewProvider().getVirtualFile())) == null ? 0 : pointers.getSize();
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(20);
        }
        if (pointer2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(21);
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(Document document, FrozenDocument frozen, List<DocumentEvent> events) {
        SmartPointerTracker list2;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        SmartPointerTracker smartPointerTracker = list2 = file2 == null ? null : this.getTracker(file2);
        if (list2 != null) {
            list2.updateMarkers(frozen, events);
        }
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        SmartPointerTracker list2;
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(22);
        }
        if ((list2 = this.getTracker(file2)) != null) {
            list2.updatePointerTargetsAfterReparse();
        }
    }

    private void processQueue() {
        SmartPointerTracker.PointerReference reference;
        while ((reference = (SmartPointerTracker.PointerReference)this.myQueue.poll()) != null) {
            SmartPointerTracker pointers = (SmartPointerTracker)this.myTrackerMap.get(reference.file);
            if (pointers == null) continue;
            pointers.removeReference(reference, reference.trackerMap);
        }
    }

    Project getProject() {
        return this.myProject;
    }

    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiElementPointer";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiFileRangePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fastenBelts";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiElementPointer";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPointer";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiFileRangePointer";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trackPointer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removePointer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTracker";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPointersNumber";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pointToTheSameElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updatePointerTargetsAfterReparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

