/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.TestRunnerUtil;
import com.intellij.rt.execution.junit.ComparisonDetailsExtractor;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.DeafStream;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class JUnit3IdeaTestRunner
extends TestRunner
implements IdeaTestRunner {
    private SMTestListener myTestsListener;
    private ArrayList myListeners;

    public JUnit3IdeaTestRunner() {
        super(DeafStream.DEAF_PRINT_STREAM);
    }

    public void createListeners(ArrayList listeners, int count) {
        this.myTestsListener = new SMTestListener();
        this.myListeners = listeners;
    }

    public int startRunnerWithArgs(String[] args, String name, int count, boolean sendTree) {
        this.setPrinter(new MockResultPrinter());
        try {
            Test suite = TestRunnerUtil.getTestSuite(this, args);
            if (suite == null) {
                return -1;
            }
            return this.doRun(suite).wasSuccessful() ? 0 : -1;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -2;
        }
    }

    public void clearStatus() {
        super.clearStatus();
    }

    public void runFailed(String message) {
        super.runFailed(message);
    }

    public Object getTestToStart(String[] args, String name) {
        return TestRunnerUtil.getTestSuite(this, args);
    }

    public List getChildTests(Object description) {
        return JUnit3IdeaTestRunner.getTestCasesOf((Test)description);
    }

    public String getTestClassName(Object child) {
        return child instanceof TestSuite ? ((TestSuite)child).getName() : child.getClass().getName();
    }

    public String getStartDescription(Object child) {
        Test test = (Test)child;
        if (test instanceof TestCase) {
            return test.getClass().getName() + "," + ((TestCase)test).getName();
        }
        return test.toString();
    }

    protected TestResult createTestResult() {
        TestResult testResult = super.createTestResult();
        testResult.addListener((TestListener)this.myTestsListener);
        try {
            for (int i = 0; i < this.myListeners.size(); ++i) {
                final IDEAJUnitListener junitListener = (IDEAJUnitListener)Class.forName((String)this.myListeners.get(i)).newInstance();
                testResult.addListener(new TestListener(){

                    public void addError(Test test, Throwable t) {
                    }

                    public void addFailure(Test test, AssertionFailedError t) {
                    }

                    public void endTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testFinished(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }

                    public void startTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testStarted(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testResult;
    }

    public TestResult doRun(Test suite, boolean wait) {
        TestResult testResult = super.doRun(suite, wait);
        this.myTestsListener.finishSuite();
        return testResult;
    }

    static Vector getTestCasesOf(Test test) {
        Vector testCases = new Vector();
        if (test instanceof TestRunnerUtil.SuiteMethodWrapper) {
            test = ((TestRunnerUtil.SuiteMethodWrapper)test).getSuite();
        }
        if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            Enumeration each = testSuite.tests();
            while (each.hasMoreElements()) {
                Object childTest = each.nextElement();
                if (childTest instanceof TestSuite && !((TestSuite)childTest).tests().hasMoreElements()) continue;
                testCases.addElement(childTest);
            }
        }
        return testCases;
    }

    private static class SMTestListener
    implements TestListener {
        private String myClassName;
        private long myCurrentTestStart;

        private SMTestListener() {
        }

        public void addError(Test test, Throwable e) {
            this.testFailure(e, "testFailed", SMTestListener.getMethodName(test));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testFailure(Throwable failure, String messageName, String methodName) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("name", methodName);
            long duration = System.currentTimeMillis() - this.myCurrentTestStart;
            if (duration > 0L) {
                attrs.put("duration", Long.toString(duration));
            }
            try {
                String trace = this.getTrace(failure);
                ComparisonFailureData notification = null;
                if (failure instanceof FileComparisonFailure) {
                    FileComparisonFailure comparisonFailure = (FileComparisonFailure)failure;
                    notification = new ComparisonFailureData(comparisonFailure.getExpected(), comparisonFailure.getActual(), comparisonFailure.getFilePath(), comparisonFailure.getActualFilePath());
                } else if (failure instanceof ComparisonFailure || failure.getClass().getName().equals("org.junit.ComparisonFailure")) {
                    notification = new ComparisonFailureData(ComparisonDetailsExtractor.getExpected((Throwable)failure), ComparisonDetailsExtractor.getActual((Throwable)failure));
                }
                ComparisonFailureData.registerSMAttributes((ComparisonFailureData)notification, (String)trace, (String)failure.getMessage(), attrs, (Throwable)failure);
            }
            catch (Throwable e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                e.printStackTrace(writer);
                ComparisonFailureData.registerSMAttributes(null, (String)stringWriter.toString(), (String)e.getMessage(), attrs, (Throwable)e);
            }
            finally {
                System.out.println("\n" + MapSerializerUtil.asString(messageName, attrs));
            }
        }

        public String getTrace(Throwable failure) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            failure.printStackTrace(writer);
            return stringWriter.toString();
        }

        private static String getMethodName(Test test) {
            String toString = test.toString();
            int braceIdx = toString.indexOf("(");
            return braceIdx > 0 ? toString.substring(0, braceIdx) : toString;
        }

        private static String getClassName(Test test) {
            String toString = test.toString();
            int braceIdx = toString.indexOf("(");
            return braceIdx > 0 && toString.endsWith(")") ? toString.substring(braceIdx + 1, toString.length() - 1) : null;
        }

        public void addFailure(Test test, AssertionFailedError e) {
            this.addError(test, (Throwable)e);
        }

        public void endTest(Test test) {
            long duration = System.currentTimeMillis() - this.myCurrentTestStart;
            System.out.println("\n##teamcity[testFinished name='" + SMTestListener.escapeName(SMTestListener.getMethodName(test)) + (duration > 0L ? "' duration='" + Long.toString(duration) : "") + "']");
        }

        public void startTest(Test test) {
            this.myCurrentTestStart = System.currentTimeMillis();
            String className = SMTestListener.getClassName(test);
            if (className != null && !className.equals(this.myClassName)) {
                this.finishSuite();
                this.myClassName = className;
                System.out.println("##teamcity[testSuiteStarted name ='" + SMTestListener.escapeName(this.myClassName) + "' locationHint='java:suite://" + SMTestListener.escapeName(className) + "']");
            }
            String methodName = SMTestListener.getMethodName(test);
            System.out.println("##teamcity[testStarted name='" + SMTestListener.escapeName(methodName) + "' locationHint='java:test://" + SMTestListener.escapeName(className + "/" + methodName) + "']");
        }

        protected void finishSuite() {
            if (this.myClassName != null) {
                System.out.println("##teamcity[testSuiteFinished name='" + SMTestListener.escapeName(this.myClassName) + "']");
            }
        }

        private static String escapeName(String str) {
            return MapSerializerUtil.escapeStr(str, MapSerializerUtil.STD_ESCAPER);
        }
    }

    public static class MockResultPrinter
    extends ResultPrinter {
        public MockResultPrinter() {
            super(DeafStream.DEAF_PRINT_STREAM);
        }
    }
}

