/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.AddRepositoryLocationDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeRootNode;
import org.jetbrains.idea.svn.dialogs.SvnRepositoryTreeCellRenderer;
import org.jetbrains.idea.svn.dialogs.browser.CheckoutOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.CopyOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.DeleteOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.DiffOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.ExportOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.ImportOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.MkdirOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.OpeningExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.KeepingExpandedExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.SyntheticWorker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;

public class RepositoryBrowserDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(RepositoryBrowserDialog.class);
    private final Project myProject;
    protected final SvnVcs myVCS;
    private RepositoryBrowserComponent myRepositoryBrowser;
    private final DeleteAction myDeleteAction;
    private AnAction copyUrlAction;
    private AnAction mkDirAction;
    private final boolean myShowFiles;
    @NonNls
    public static final String PLACE_TOOLBAR = "RepositoryBrowser.Toolbar";
    @NonNls
    private static final String PLACE_MENU = "RepositoryBrowser.Menu";
    private final String myRepositoriesLabelText;
    protected JLabel myRepositoriesLabel;

    public RepositoryBrowserDialog(Project project) {
        this(project, true, null);
    }

    public RepositoryBrowserDialog(Project project, boolean showFiles, @Nullable String repositoriesLabelText) {
        super(project, true);
        this.myRepositoriesLabelText = repositoriesLabelText == null ? "Repositories:" : repositoriesLabelText;
        this.myShowFiles = showFiles;
        this.myProject = project;
        this.myVCS = SvnVcs.getInstance(project);
        this.setTitle("SVN Repository Browser");
        this.setResizable(true);
        this.setOKButtonText(CommonBundle.getCloseButtonText());
        this.getHelpAction().setEnabled(true);
        Disposer.register((Disposable)project, (Disposable)this.getDisposable());
        this.myDeleteAction = new DeleteAction(this.getRepositoryBrowser());
        this.init();
    }

    protected String getHelpId() {
        return "reference.svn.repository";
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getHelpAction()};
        if (actionArray == null) {
            RepositoryBrowserDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected String getDimensionServiceKey() {
        return "svn.repositoryBrowser";
    }

    protected boolean showImportAction() {
        return true;
    }

    public JComponent createToolbar(boolean horizontal, AnAction ... additionalActions) {
        DefaultActionGroup group = new DefaultActionGroup();
        final RepositoryBrowserComponent browser = this.getRepositoryBrowser();
        group.add((AnAction)new AddLocationAction(browser));
        group.add((AnAction)new EditLocationAction(browser));
        group.add((AnAction)new DiscardLocationAction(browser));
        group.add((AnAction)new DetailsAction());
        group.addSeparator();
        RefreshAction refreshAction = new RefreshAction(browser);
        refreshAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), browser);
        group.add((AnAction)refreshAction);
        this.copyUrlAction = new CopyUrlAction();
        this.copyUrlAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(155, 650)), (JComponent)browser);
        this.mkDirAction = new MkDirAction(browser);
        this.mkDirAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(155, 520)), (JComponent)browser);
        AnAction action = CommonActionsManager.getInstance().createCollapseAllAction(new TreeExpander(){

            public boolean canExpand() {
                return false;
            }

            public void collapseAll() {
                JTree tree = browser.getRepositoryTree();
                for (int row = tree.getRowCount() - 1; row >= 0; --row) {
                    tree.collapseRow(row);
                }
            }

            public boolean canCollapse() {
                return true;
            }
        }, (JComponent)browser);
        group.add(action);
        if (!ArrayUtil.isEmpty((Object[])additionalActions)) {
            group.addSeparator();
            group.addAll(additionalActions);
        }
        return ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)group, horizontal).getComponent();
    }

    protected JPopupMenu createPopup(boolean toolWindow) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup newGroup = new DefaultActionGroup("_New", true);
        RepositoryBrowserComponent browser = this.getRepositoryBrowser();
        newGroup.add((AnAction)new AddLocationAction(browser));
        newGroup.add((AnAction)new MkDirAction(browser));
        group.add((AnAction)newGroup);
        group.addSeparator();
        if (toolWindow) {
            group.add(actionManager.getAction("EditSource"));
            group.add((AnAction)new HistoryAction());
        }
        group.add((AnAction)new CheckoutAction());
        group.add((AnAction)new DiffAction());
        group.add((AnAction)new BrowseChangesAction());
        group.addSeparator();
        group.add((AnAction)new ImportAction());
        group.add((AnAction)new ExportAction());
        group.addSeparator();
        group.add((AnAction)new CopyOrMoveAction("Branch or Tag...", "copy.dialog.title", false));
        group.add((AnAction)new CopyOrMoveAction("_Move or Rename...", "move.dialog.title", true));
        group.add((AnAction)this.myDeleteAction);
        group.add(this.copyUrlAction);
        group.addSeparator();
        group.add((AnAction)new RefreshAction(browser));
        group.add((AnAction)new EditLocationAction(browser));
        group.add((AnAction)new DiscardLocationAction(browser));
        ActionPopupMenu menu = actionManager.createActionPopupMenu(PLACE_MENU, (ActionGroup)group);
        return menu.getComponent();
    }

    public JComponent createCenterPanel() {
        JPanel parentPanel = new JPanel(new BorderLayout());
        JPanel top = new JPanel();
        BoxLayout layout = new BoxLayout(top, 0);
        top.setLayout(layout);
        this.myRepositoriesLabel = new JLabel(this.myRepositoriesLabelText);
        top.add(this.myRepositoriesLabel);
        top.add(this.createToolbar(true, null));
        parentPanel.add((Component)top, "North");
        JComponent panel = this.createBrowserComponent(false);
        parentPanel.add((Component)panel, "Center");
        return parentPanel;
    }

    public JComponent createBrowserComponent(final boolean toolWindow) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridwidth = 1;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridwidth = 2;
        ++gc.gridy;
        gc.gridheight = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 17;
        panel.add((Component)this.getRepositoryBrowser(), gc);
        ++gc.gridy;
        gc.weighty = 0.0;
        gc.fill = 2;
        panel.add((Component)new JLabel(), gc);
        Collection<String> urls = SvnApplicationSettings.getInstance().getCheckoutURLs();
        ArrayList<Url> svnURLs = new ArrayList<Url>();
        for (String url : urls) {
            try {
                svnURLs.add(SvnUtil.createUrl(url));
            }
            catch (SvnBindException svnBindException) {}
        }
        this.getRepositoryBrowser().setRepositoryURLs(svnURLs.toArray(new Url[0]), this.myShowFiles);
        this.getRepositoryBrowser().getRepositoryTree().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                JPopupMenu popupMenu;
                JTree tree = RepositoryBrowserDialog.this.getRepositoryBrowser().getRepositoryTree();
                int row = tree.getRowForLocation(x, y);
                if (row >= 0) {
                    tree.setSelectionRow(row);
                }
                if ((popupMenu = RepositoryBrowserDialog.this.createPopup(toolWindow)) != null) {
                    popupMenu.show(comp, x, y);
                }
            }
        });
        return panel;
    }

    protected RepositoryBrowserComponent getRepositoryBrowser() {
        if (this.myRepositoryBrowser == null) {
            this.myRepositoryBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
            this.myRepositoryBrowser.setPreferredSize(new Dimension(300, 300));
        }
        return this.myRepositoryBrowser;
    }

    public void disposeRepositoryBrowser() {
        if (this.myRepositoryBrowser != null) {
            Disposer.dispose((Disposable)this.myRepositoryBrowser);
            this.myRepositoryBrowser = null;
        }
    }

    protected void dispose() {
        super.dispose();
        this.disposeRepositoryBrowser();
    }

    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.getRepositoryBrowser().getPreferredFocusedComponent();
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public boolean isOKActionEnabled() {
        return true;
    }

    public String getSelectedURL() {
        return this.getRepositoryBrowser().getSelectedURL();
    }

    @Nullable
    protected RepositoryTreeNode getSelectedNode() {
        return this.getRepositoryBrowser().getSelectedNode();
    }

    private static void setEnabled(@NotNull AnActionEvent e, @Nullable RepositoryTreeNode node) {
        if (e == null) {
            RepositoryBrowserDialog.$$$reportNull$$$0(1);
        }
        RepositoryBrowserDialog.setEnabled(e, node, false);
    }

    private static void setEnabled(@NotNull AnActionEvent e, @Nullable RepositoryTreeNode node, boolean isRunning) {
        if (e == null) {
            RepositoryBrowserDialog.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(node != null && (node.getSVNDirEntry() == null || node.getSVNDirEntry().isDirectory()) && !isRunning);
    }

    @Nullable
    private File selectFile(String title, String description) {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(title);
        fcd.setDescription(description);
        fcd.setHideIgnored(false);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fcd, (Project)this.myProject, null);
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        if (path.endsWith(":")) {
            return new File(path + "/");
        }
        return new File(path);
    }

    protected static void doMkdir(Url url, String comment, Project project) {
        Ref exception = new Ref();
        Runnable command = () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.browser.creating", url.toString()));
            }
            SvnVcs vcs = SvnVcs.getInstance(project);
            Target target = Target.on(url);
            try {
                vcs.getFactoryFromSettings().createBrowseClient().createDirectory(target, comment, false);
            }
            catch (VcsException e) {
                exception.set((Object)e);
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.text.create.remote.folder", new Object[0]), false, project);
        if (!exception.isNull()) {
            Messages.showErrorDialog((String)((Exception)exception.get()).getMessage(), (String)SvnBundle.message("message.text.error", new Object[0]));
        }
    }

    private void doCopy(Url src, Url dst, boolean move, String comment) {
        Ref exception = new Ref();
        Runnable command = () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(move ? SvnBundle.message("progress.text.browser.moving", src) : SvnBundle.message("progress.text.browser.copying", src));
                progress.setText2(SvnBundle.message("progress.text.browser.remote.destination", dst));
            }
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            try {
                vcs.getFactoryFromSettings().createCopyMoveClient().copy(Target.on(src), Target.on(dst), Revision.HEAD, true, move, comment, null);
            }
            catch (VcsException e) {
                exception.set((Object)e);
            }
        };
        String progressTitle = move ? SvnBundle.message("progress.title.browser.move", new Object[0]) : SvnBundle.message("progress.title.browser.copy", new Object[0]);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, progressTitle, false, this.myProject);
        if (!exception.isNull()) {
            Messages.showErrorDialog((String)((Exception)exception.get()).getMessage(), (String)SvnBundle.message("message.text.error", new Object[0]));
        }
    }

    protected void doCheckout(@Nullable CheckoutProvider.Listener listener, RepositoryTreeNode selectedNode) {
        File dir;
        if (selectedNode == null) {
            return;
        }
        Url url = selectedNode.getURL();
        String relativePath = "";
        DirectoryEntry entry = selectedNode.getSVNDirEntry();
        if (entry != null) {
            if (entry.getRepositoryRoot() != null) {
                if (!entry.getRepositoryRoot().equals(url)) {
                    relativePath = SvnUtil.getRelativeUrl(entry.getRepositoryRoot(), url);
                }
            } else {
                relativePath = entry.getRelativePath();
            }
        } else {
            relativePath = url.getPath();
        }
        if ((dir = this.selectFile(SvnBundle.message("svn.checkout.destination.directory.title", new Object[0]), SvnBundle.message("svn.checkout.destination.directory.description", new Object[0]))) == null) {
            return;
        }
        Project p = this.myProject;
        CheckoutOptionsDialog dialog = new CheckoutOptionsDialog(p, url, dir, SvnUtil.getVirtualFile(dir.getAbsolutePath()), relativePath);
        dialog.show();
        dir = dialog.getTarget();
        if (dialog.isOK() && dir != null) {
            Revision revision;
            try {
                revision = dialog.getRevision();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.checkout", e.getMessage()), (String)SvnBundle.message("message.title.check.out", new Object[0]));
                return;
            }
            SvnCheckoutProvider.doCheckout(this.myProject, dir, url, revision, dialog.getDepth(), dialog.isIgnoreExternals(), listener);
        }
    }

    protected boolean doImport() {
        File dir = this.selectFile("Import Directory", "Select directory to import into repository");
        if (dir == null) {
            return false;
        }
        RepositoryTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return false;
        }
        Url url = selectedNode.getURL();
        ImportOptionsDialog dialog = new ImportOptionsDialog(this.myProject, url, dir);
        dialog.show();
        VcsConfiguration.getInstance((Project)this.myProject).saveCommitMessage(dialog.getCommitMessage());
        if (dialog.isOK()) {
            File src = dialog.getTarget();
            boolean ignored = dialog.isIncludeIgnored();
            String message = dialog.getCommitMessage();
            SvnCheckoutProvider.doImport(this.myProject, src, url, dialog.getDepth(), ignored, message);
            selectedNode.reload(false);
        }
        return dialog.isOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnifiedDiff(File targetFile, Url sourceURL, Url targetURL) {
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(targetFile));
            this.myVCS.getFactoryFromSettings().createDiffClient().unifiedDiff(Target.on(sourceURL, Revision.HEAD), Target.on(targetURL, Revision.HEAD), os);
        }
        catch (VcsException | IOException e) {
            LOG.info(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    private void doGraphicalDiff(Url sourceURL, Url targetURL) throws VcsException {
        List<Change> changes = this.myVCS.getFactoryFromSettings().createDiffClient().compare(Target.on(sourceURL), Target.on(targetURL));
        this.showDiffEditorResults(changes, sourceURL.getTail(), targetURL.getTail());
    }

    private void showDiffEditorResults(Collection<Change> changes, String sourceTitle, String targetTitle) {
        String title = SvnBundle.message("repository.browser.compare.title", sourceTitle, targetTitle);
        SwingUtilities.invokeLater(() -> {
            ChangeListViewerDialog dlg = new ChangeListViewerDialog((Component)this.myRepositoryBrowser, this.myProject, changes, true);
            dlg.setTitle(title);
            dlg.show();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/RepositoryBrowserDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/RepositoryBrowserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class DetailsAction
    extends ToggleAction {
        private boolean myIsSelected;

        protected DetailsAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setDescription(SvnBundle.message("repository.browser.details.action", new Object[0]));
            e.getPresentation().setText(SvnBundle.message("repository.browser.details.action", new Object[0]));
            e.getPresentation().setIcon(AllIcons.Actions.Annotate);
            super.update(e);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myIsSelected;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myIsSelected = state;
            SvnRepositoryTreeCellRenderer r = new SvnRepositoryTreeCellRenderer();
            r.setShowDetails(state);
            RepositoryBrowserDialog.this.getRepositoryBrowser().getRepositoryTree().setCellRenderer((TreeCellRenderer)((Object)r));
        }
    }

    protected class BrowseChangesAction
    extends AnAction {
        public BrowseChangesAction() {
            super(SvnBundle.message("repository.browser.browse.changes.action", new Object[0]), SvnBundle.message("repository.browser.browse.changes.description", new Object[0]), null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getSelectedNode();
            if (node == null) {
                return;
            }
            Url url = node.getURL();
            AbstractVcsHelper.getInstance((Project)RepositoryBrowserDialog.this.myProject).showChangesBrowser(RepositoryBrowserDialog.this.myVCS.getCommittedChangesProvider(), (RepositoryLocation)new SvnRepositoryLocation(url), "Changes in " + url.toString(), null);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode() != null);
        }
    }

    protected class CheckoutAction
    extends AnAction {
        protected CheckoutAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("_Checkout...", true);
            RepositoryBrowserDialog.setEnabled(e, RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode());
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode selectedNode = RepositoryBrowserDialog.this.getSelectedNode();
            if (!ModalityState.NON_MODAL.equals(ModalityState.current())) {
                RepositoryBrowserDialog.this.doCancelAction();
            }
            RepositoryBrowserDialog.this.doCheckout(ProjectLevelVcsManager.getInstance((Project)RepositoryBrowserDialog.this.myProject).getCompositeCheckoutListener(), selectedNode);
        }
    }

    protected class ExportAction
    extends AnAction {
        protected ExportAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("_Export...");
            e.getPresentation().setEnabled(RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode selectedNode = RepositoryBrowserDialog.this.getSelectedNode();
            if (selectedNode == null) {
                return;
            }
            Url url = selectedNode.getURL();
            File dir = RepositoryBrowserDialog.this.selectFile("Destination directory", "Select export destination directory");
            if (dir == null) {
                return;
            }
            Project p = (Project)e.getData(CommonDataKeys.PROJECT);
            ExportOptionsDialog dialog = new ExportOptionsDialog(p, url, dir);
            if (dialog.showAndGet()) {
                SvnCheckoutProvider.doExport(RepositoryBrowserDialog.this.myProject, dir, url, dialog.getDepth(), dialog.isIgnoreExternals(), dialog.isForce(), dialog.getEOLStyle());
            }
        }
    }

    protected class ImportAction
    extends AnAction {
        protected ImportAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(RepositoryBrowserDialog.this.showImportAction());
            e.getPresentation().setText(SvnBundle.message("repository.browser.import.action", new Object[0]));
            RepositoryBrowserDialog.setEnabled(e, RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode(), ProjectLevelVcsManager.getInstance((Project)RepositoryBrowserDialog.this.myProject).isBackgroundVcsOperationRunning());
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryBrowserDialog.this.doImport();
        }
    }

    private static class AfterDeletionSelectionInstaller
    implements Expander {
        private final RepositoryTreeNode myParentNode;
        private final String myDeletedNodeName;
        private final boolean myIsFolder;
        private final RepositoryBrowserComponent myBrowserComponent;

        private AfterDeletionSelectionInstaller(RepositoryTreeNode deletedNode, RepositoryBrowserComponent browserComponent) {
            this.myBrowserComponent = browserComponent;
            this.myParentNode = (RepositoryTreeNode)deletedNode.getParent();
            this.myDeletedNodeName = deletedNode.toString();
            this.myIsFolder = !deletedNode.isLeaf();
        }

        @Override
        public void onBeforeRefresh(RepositoryTreeNode node) {
        }

        @Override
        public void onAfterRefresh(RepositoryTreeNode node) {
            TreeNode nodeToSelect = this.myParentNode.getNextChildByKey(this.myDeletedNodeName, this.myIsFolder);
            nodeToSelect = nodeToSelect == null ? this.myParentNode : nodeToSelect;
            this.myBrowserComponent.setSelectedNode(nodeToSelect);
        }
    }

    public static class DeleteAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public DeleteAction(RepositoryBrowserComponent browserComponent) {
            super("_Delete...");
            this.myBrowserComponent = browserComponent;
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), this.myBrowserComponent);
        }

        public void update(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            e.getPresentation().setEnabled(node != null && node.getSVNDirEntry() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            String message;
            Url url;
            boolean successful;
            DeleteOptionsDialog dialog = new DeleteOptionsDialog(this.myBrowserComponent.getProject());
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            dialog.show();
            VcsConfiguration.getInstance((Project)this.myBrowserComponent.getProject()).saveCommitMessage(dialog.getCommitMessage());
            if (dialog.isOK() && (successful = this.doDelete(url = node.getURL(), message = dialog.getCommitMessage()))) {
                SyntheticWorker worker = new SyntheticWorker(url);
                worker.removeSelf();
                RepositoryTreeNode parentNode = (RepositoryTreeNode)node.getParent();
                parentNode.reload(new KeepingExpandedExpander(this.myBrowserComponent, new AfterDeletionSelectionInstaller(node, this.myBrowserComponent)), false);
            }
        }

        private boolean doDelete(Url url, String comment) {
            Ref exception = new Ref();
            Project project = this.myBrowserComponent.getProject();
            Runnable command = () -> {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress != null) {
                    progress.setText(SvnBundle.message("progres.text.deleting", url.toString()));
                }
                SvnVcs vcs = SvnVcs.getInstance(project);
                try {
                    vcs.getFactoryFromSettings().createDeleteClient().delete(url, comment);
                }
                catch (VcsException e) {
                    exception.set((Object)e);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.browser.delete", new Object[0]), false, project);
            if (!exception.isNull()) {
                Messages.showErrorDialog((String)((Exception)exception.get()).getMessage(), (String)SvnBundle.message("message.text.error", new Object[0]));
            }
            return exception.isNull();
        }
    }

    protected class CopyUrlAction
    extends AnAction {
        protected CopyUrlAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Copy URL...");
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            e.getPresentation().setEnabled(node != null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode treeNode = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            if (treeNode != null) {
                String url = treeNode.getURL().toString();
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(url));
            }
        }
    }

    private static interface CopyMoveReloadHelper {
        public static final CopyMoveReloadHelper EMPTY = new CopyMoveReloadHelper(){

            @Override
            public void doRefresh() {
            }

            @Override
            public void doSynthetic() {
            }

            @Override
            @Nullable
            public Url parent() {
                return null;
            }
        };

        public void doRefresh();

        public void doSynthetic();

        @Nullable
        public Url parent();
    }

    private static class MoveSourceReloader
    implements CopyMoveReloadHelper {
        private final RepositoryTreeNode mySource;
        private final RepositoryTreeNode myParent;

        private MoveSourceReloader(RepositoryTreeNode source) {
            this.mySource = source;
            this.myParent = (RepositoryTreeNode)source.getParent();
        }

        @Override
        public void doRefresh() {
            this.myParent.reload(false);
        }

        @Override
        public void doSynthetic() {
            SyntheticWorker worker = new SyntheticWorker(this.mySource.getURL());
            worker.removeSelf();
        }

        @Override
        public Url parent() {
            return this.myParent.getURL();
        }
    }

    private static class TargetReloader
    implements CopyMoveReloadHelper {
        private final RepositoryTreeNode myDialogParent;
        private final Url myDst;
        private final RepositoryTreeNode mySourceNode;
        private final RepositoryTreeNode myRoot;
        private final RepositoryBrowserComponent myBrowserComponent;
        private final String myNewName;

        private TargetReloader(CopyOptionsDialog dialog, RepositoryTreeNode node, RepositoryTreeNode root, RepositoryBrowserComponent browserComponent) {
            this.myDialogParent = dialog.getTargetParentNode();
            this.myDst = dialog.getTargetURL();
            this.mySourceNode = node;
            this.myRoot = root;
            this.myBrowserComponent = browserComponent;
            this.myNewName = dialog.getName();
        }

        @Override
        public void doRefresh() {
            TreeNode[] oldPath = this.myDialogParent.getSelfPath();
            TreeNode[] correctedPath = new TreeNode[oldPath.length + 1];
            System.arraycopy(oldPath, 0, correctedPath, 1, oldPath.length);
            this.myRoot.reload(new OpeningExpander(oldPath, this.myBrowserComponent, this.myDialogParent), false);
        }

        @Override
        public void doSynthetic() {
            SyntheticWorker parentWorker = new SyntheticWorker(this.myDialogParent.getURL());
            parentWorker.addSyntheticChildToSelf(this.myDst, this.myRoot.getURL(), this.myNewName, !this.mySourceNode.isLeaf());
            parentWorker.copyTreeToSelf(this.mySourceNode);
        }

        @Override
        public Url parent() {
            return this.myDialogParent.getURL();
        }
    }

    protected class CopyOrMoveAction
    extends AnAction {
        private final String myActionName;
        private final String myDialogTitleKey;
        private final boolean myMove;

        public CopyOrMoveAction(String actionName, String dialogTitleKey, boolean move) {
            this.myActionName = actionName;
            this.myDialogTitleKey = dialogTitleKey;
            this.myMove = move;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText(this.myActionName);
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            e.getPresentation().setEnabled(node != null && node.getSVNDirEntry() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getSelectedNode();
            if (node == null) {
                return;
            }
            RepositoryTreeNode rootNode = node;
            while (!rootNode.isRepositoryRoot()) {
                rootNode = (RepositoryTreeNode)rootNode.getParent();
            }
            CopyOptionsDialog dialog = new CopyOptionsDialog(SvnBundle.message(this.myDialogTitleKey, new Object[0]), RepositoryBrowserDialog.this.myProject, rootNode, node, !this.myMove);
            dialog.show();
            VcsConfiguration.getInstance((Project)RepositoryBrowserDialog.this.myProject).saveCommitMessage(dialog.getCommitMessage());
            if (dialog.isOK()) {
                Url dst = dialog.getTargetURL();
                Url src = dialog.getSourceURL();
                String path = src.getPath();
                int folder = path.replace('\\', '/').lastIndexOf(47);
                if (folder != -1) {
                    int result;
                    String lastFolder = path.substring(folder + 1);
                    if (this.myMove && "trunk".equalsIgnoreCase(lastFolder) && 0 != (result = Messages.showOkCancelDialog((Project)RepositoryBrowserDialog.this.myProject, (String)("You are about to move folder named '" + lastFolder + "'. Are you sure?"), (String)SvnBundle.message(this.myDialogTitleKey, new Object[0]), (Icon)Messages.getWarningIcon()))) {
                        return;
                    }
                }
                String message = dialog.getCommitMessage();
                RepositoryBrowserDialog.this.doCopy(src, dst, this.myMove, message);
                CopyMoveReloadHelper sourceReloader = this.myMove ? new MoveSourceReloader(node) : CopyMoveReloadHelper.EMPTY;
                TargetReloader destinationReloader = new TargetReloader(dialog, node, rootNode, RepositoryBrowserDialog.this.myRepositoryBrowser);
                sourceReloader.doSynthetic();
                destinationReloader.doSynthetic();
                if (!this.myMove || !Comparing.equal((Object)sourceReloader.parent(), (Object)destinationReloader.parent())) {
                    destinationReloader.doRefresh();
                }
                sourceReloader.doRefresh();
            }
        }
    }

    protected class DiffAction
    extends AnAction {
        protected DiffAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Compare With...", true);
            RepositoryBrowserDialog.setEnabled(e, RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode());
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            if (node == null) {
                return;
            }
            while (node.getSVNDirEntry() != null) {
                node = (RepositoryTreeNode)node.getParent();
            }
            Url root = node.getURL();
            RepositoryTreeNode selectedNode = RepositoryBrowserDialog.this.getSelectedNode();
            if (selectedNode == null) {
                return;
            }
            Url sourceURL = selectedNode.getURL();
            DiffOptionsDialog dialog = new DiffOptionsDialog(RepositoryBrowserDialog.this.myProject, root, sourceURL);
            if (dialog.showAndGet()) {
                boolean cancelable;
                Runnable command;
                Url targetURL = dialog.getTargetURL();
                if (dialog.isReverseDiff()) {
                    targetURL = sourceURL;
                    sourceURL = dialog.getTargetURL();
                }
                Url sURL = sourceURL;
                Url tURL = targetURL;
                if (dialog.isUnifiedDiff()) {
                    File targetFile = dialog.getTargetFile();
                    command = () -> {
                        targetFile.getParentFile().mkdirs();
                        RepositoryBrowserDialog.this.doUnifiedDiff(targetFile, sURL, tURL);
                    };
                    cancelable = false;
                } else {
                    command = () -> {
                        try {
                            RepositoryBrowserDialog.this.doGraphicalDiff(sURL, tURL);
                        }
                        catch (VcsException ex) {
                            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)RepositoryBrowserDialog.this.myProject, (String)ex.getMessage(), (String)"Error"), null, (Project)RepositoryBrowserDialog.this.myProject);
                        }
                    };
                    cancelable = true;
                }
                ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.computing.difference", new Object[0]), cancelable, RepositoryBrowserDialog.this.myProject);
            }
        }
    }

    public static class MkDirAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public MkDirAction(RepositoryBrowserComponent browserComponent) {
            super(SvnBundle.message("repository.browser.new.folder.action", new Object[0]));
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            RepositoryBrowserDialog.setEnabled(e, this.myBrowserComponent.getSelectedNode());
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            if (node == null) {
                return;
            }
            Project project = this.myBrowserComponent.getProject();
            MkdirOptionsDialog dialog = new MkdirOptionsDialog(project, node.getURL());
            dialog.show();
            VcsConfiguration.getInstance((Project)project).saveCommitMessage(dialog.getCommitMessage());
            if (dialog.isOK()) {
                Url url = dialog.getURL();
                String message = dialog.getCommitMessage();
                RepositoryBrowserDialog.doMkdir(url, message, project);
                Url repositoryUrl = node.getSVNDirEntry() == null ? node.getURL() : node.getSVNDirEntry().getRepositoryRoot();
                SyntheticWorker worker = new SyntheticWorker(node.getURL());
                worker.addSyntheticChildToSelf(url, repositoryUrl, dialog.getName(), true);
                node.reload(false);
            }
        }
    }

    protected static class DiscardLocationAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public DiscardLocationAction(RepositoryBrowserComponent browserComponent) {
            super(SvnBundle.message("repository.browser.discard.location.action", new Object[0]), SvnBundle.message("repository.browser.discard.location.action", new Object[0]), AllIcons.General.Remove);
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            e.getPresentation().setText(SvnBundle.message("repository.browser.discard.location.action", new Object[0]), true);
            e.getPresentation().setIcon(AllIcons.General.Remove);
            e.getPresentation().setEnabled(node != null && node.getParent() instanceof RepositoryTreeRootNode);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            if (node == null) {
                return;
            }
            Url url = node.getURL();
            if (url != null) {
                int rc = Messages.showYesNoDialog((Project)this.myBrowserComponent.getProject(), (String)SvnBundle.message("repository.browser.discard.location.prompt", url.toString()), (String)SvnBundle.message("repository.browser.discard.location.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (rc != 0) {
                    return;
                }
                SvnApplicationSettings.getInstance().removeCheckoutURL(url.toString());
                this.myBrowserComponent.removeURL(url);
            }
        }
    }

    protected static class EditLocationAction
    extends AnAction {
        @NotNull
        private final RepositoryBrowserComponent myBrowserComponent;

        public EditLocationAction(@NotNull RepositoryBrowserComponent browserComponent) {
            if (browserComponent == null) {
                EditLocationAction.$$$reportNull$$$0(0);
            }
            super(SvnBundle.message("repository.browser.edit.location.menu.item", new Object[0]));
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            if (e.getPlace().equals(RepositoryBrowserDialog.PLACE_TOOLBAR)) {
                e.getPresentation().setDescription(SvnBundle.message("repository.browser.edit.location.menu.item", new Object[0]));
                e.getPresentation().setText(SvnBundle.message("repository.browser.edit.location.menu.item", new Object[0]));
                e.getPresentation().setIcon(AllIcons.Actions.EditSource);
            }
            e.getPresentation().setEnabled(node != null && node.getParent() instanceof RepositoryTreeRootNode);
        }

        public void actionPerformed(AnActionEvent e) {
            Url url;
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            if (node == null || !(node.getParent() instanceof RepositoryTreeRootNode)) {
                return;
            }
            final Url oldUrl = node.getURL();
            SvnApplicationSettings settings = SvnApplicationSettings.getInstance();
            AddRepositoryLocationDialog dialog = new AddRepositoryLocationDialog(this.myBrowserComponent.getProject(), settings.getTypedUrlsListCopy()){

                @Override
                protected String initText() {
                    return oldUrl.toDecodedString();
                }

                @Override
                public String getTitle() {
                    return SvnBundle.message("repository.browser.edit.location.dialog.title", new Object[0]);
                }
            };
            dialog.show();
            if (dialog.getExitCode() == 0 && (url = dialog.getSelected()) != null) {
                settings.addTypedUrl(url.toDecodedString());
                settings.removeCheckoutURL(oldUrl.toString());
                settings.addCheckoutURL(url.toDecodedString());
                this.myBrowserComponent.removeURL(oldUrl);
                this.myBrowserComponent.addURL(url);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserComponent", "org/jetbrains/idea/svn/dialogs/RepositoryBrowserDialog$EditLocationAction", "<init>"));
        }
    }

    protected static class AddLocationAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public AddLocationAction(RepositoryBrowserComponent browserComponent) {
            super(SvnBundle.message("repository.browser.add.location.menu.item", new Object[0]));
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            if (e.getPlace().equals(RepositoryBrowserDialog.PLACE_TOOLBAR)) {
                e.getPresentation().setDescription(SvnBundle.message("repository.browser.add.location.action", new Object[0]));
                e.getPresentation().setText(SvnBundle.message("repository.browser.add.location.action", new Object[0]));
                e.getPresentation().setIcon(IconUtil.getAddIcon());
            }
        }

        public void actionPerformed(AnActionEvent e) {
            Url url;
            SvnApplicationSettings settings = SvnApplicationSettings.getInstance();
            AddRepositoryLocationDialog dialog = new AddRepositoryLocationDialog(this.myBrowserComponent.getProject(), settings.getTypedUrlsListCopy());
            dialog.show();
            if (dialog.getExitCode() == 0 && (url = dialog.getSelected()) != null) {
                settings.addTypedUrl(url.toDecodedString());
                settings.addCheckoutURL(url.toDecodedString());
                this.myBrowserComponent.addURL(url);
            }
        }
    }

    public static class RefreshAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public RefreshAction(RepositoryBrowserComponent browserComponent) {
            super(SvnBundle.message("action.name.refresh", new Object[0]), SvnBundle.message("repository.browser.refresh.action", new Object[0]), AllIcons.Actions.Refresh);
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText(SvnBundle.message("action.name.refresh", new Object[0]));
            e.getPresentation().setDescription(SvnBundle.message("repository.browser.refresh.action", new Object[0]));
            e.getPresentation().setIcon(AllIcons.Actions.Refresh);
            e.getPresentation().setEnabled(this.myBrowserComponent.getSelectedNode() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode selectedNode = this.myBrowserComponent.getSelectedNode();
            if (selectedNode != null) {
                selectedNode.reload(true);
            }
        }
    }

    protected class HistoryAction
    extends AnAction {
        protected HistoryAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText(SvnBundle.message("repository.browser.history.action", new Object[0]));
            e.getPresentation().setDescription(SvnBundle.message("repository.browser.history.action", new Object[0]));
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            e.getPresentation().setEnabled(node != null && node.getURL() != null && !RepositoryBrowserDialog.this.myProject.isDefault());
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getSelectedNode();
            if (node == null) {
                return;
            }
            boolean isDirectory = node.getUserObject() instanceof Url || node.getSVNDirEntry() != null && node.getSVNDirEntry().isDirectory();
            String url = node.getURL().toDecodedString();
            AbstractVcsHelper.getInstance((Project)RepositoryBrowserDialog.this.myProject).showFileHistory(RepositoryBrowserDialog.this.myVCS.getVcsHistoryProvider(), VcsUtil.getFilePathOnNonLocal((String)url, (boolean)isDirectory), (AbstractVcs)RepositoryBrowserDialog.this.myVCS);
            node.reload(false);
        }
    }
}

