/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.wizard.BeanProperty;
import com.intellij.uiDesigner.wizard.BeanPropertyTableCellEditor;
import com.intellij.uiDesigner.wizard.BeanPropertyTableCellRenderer;
import com.intellij.uiDesigner.wizard.FormProperty2BeanProperty;
import com.intellij.uiDesigner.wizard.FormPropertyTableCellRenderer;
import com.intellij.uiDesigner.wizard.WizardData;
import com.intellij.util.ui.Table;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

final class BindToNewBeanStep
extends StepAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.wizard.BindToNewBeanStep");
    private JScrollPane myScrollPane;
    private JTable myTable;
    private final WizardData myData;
    private final MyTableModel myTableModel;
    private JCheckBox myChkIsModified;
    private JCheckBox myChkSetData;
    private JCheckBox myChkGetData;
    private JPanel myPanel;

    BindToNewBeanStep(@NotNull WizardData data) {
        if (data == null) {
            BindToNewBeanStep.$$$reportNull$$$0(0);
        }
        this.myData = data;
        this.$$$setupUI$$$();
        this.myTableModel = new MyTableModel();
        this.myTable.setModel(this.myTableModel);
        this.myTable.setSelectionMode(0);
        this.myScrollPane.getViewport().setBackground(this.myTable.getBackground());
        this.myTable.setSurrendersFocusOnKeystroke(true);
        TableColumn column = this.myTable.getColumnModel().getColumn(0);
        column.setCellRenderer((TableCellRenderer)((Object)new FormPropertyTableCellRenderer(this.myData.myProject)));
        column = this.myTable.getColumnModel().getColumn(1);
        column.setCellRenderer((TableCellRenderer)((Object)new BeanPropertyTableCellRenderer()));
        column.setCellEditor(new BeanPropertyTableCellEditor());
        DefaultCellEditor editor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        editor.setClickCountToStart(1);
        this.myChkGetData.setSelected(true);
        this.myChkGetData.setEnabled(false);
        this.myChkSetData.setSelected(true);
        this.myChkSetData.setEnabled(false);
        this.myChkIsModified.setSelected(this.myData.myGenerateIsModified);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void _init() {
        LOG.assertTrue(this.myData.myBindToNewBean);
        this.myTableModel.fireTableDataChanged();
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        TableCellEditor cellEditor = this.myTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myData.myProject);
        for (int i = 0; i < this.myData.myBindings.length; ++i) {
            FormProperty2BeanProperty binding = this.myData.myBindings[i];
            if (binding.myBeanProperty == null || nameHelper.isIdentifier(binding.myBeanProperty.myName)) continue;
            throw new CommitStepException(UIDesignerBundle.message("error.X.is.not.a.valid.property.name", binding.myBeanProperty.myName));
        }
        this.myData.myGenerateIsModified = this.myChkIsModified.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/uiDesigner/wizard/BindToNewBeanStep", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myScrollPane = jBScrollPane;
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        Table table = new Table();
        this.myTable = table;
        jBScrollPane.setViewportView((Component)table);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myChkGetData = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("bind.to.bean.getdata.checkbox"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChkSetData = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("bind.to.bean.setdata.checkbox"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChkIsModified = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("bind.to.bean.ismodified.checkbox"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private final String[] myColumnNames = new String[]{UIDesignerBundle.message("column.form.field", new Object[0]), UIDesignerBundle.message("column.bean.property", new Object[0])};
        private final Class[] myColumnClasses = new Class[]{Object.class, Object.class};

        @Override
        public int getColumnCount() {
            return this.myColumnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.myColumnNames[column];
        }

        public Class getColumnClass(int column) {
            return this.myColumnClasses[column];
        }

        @Override
        public int getRowCount() {
            return ((BindToNewBeanStep)BindToNewBeanStep.this).myData.myBindings.length;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            FormProperty2BeanProperty binding = ((BindToNewBeanStep)BindToNewBeanStep.this).myData.myBindings[row];
            if (column == 0) {
                return binding.myFormProperty;
            }
            if (column == 1) {
                return binding.myBeanProperty;
            }
            throw new IllegalArgumentException("unknown column: " + column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            FormProperty2BeanProperty binding = ((BindToNewBeanStep)BindToNewBeanStep.this).myData.myBindings[row];
            if (column != 1) {
                throw new IllegalArgumentException("unknown column: " + column);
            }
            binding.myBeanProperty = (BeanProperty)value;
        }
    }
}

