/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntEnumEditor;
import com.intellij.uiDesigner.propertyInspector.properties.HGapProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VGapProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.IntEnumRenderer;
import com.intellij.uiDesigner.radComponents.FlowDropLocation;
import com.intellij.uiDesigner.radComponents.RadAbstractIndexedLayoutManager;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RadFlowLayoutManager
extends RadAbstractIndexedLayoutManager {
    private static final MyAlignProperty ALIGN_PROPERTY = new MyAlignProperty();

    @Override
    public String getName() {
        return "FlowLayout";
    }

    @Override
    public LayoutManager createLayout() {
        return new FlowLayout();
    }

    @Override
    public void writeLayout(XmlWriter writer, RadContainer radContainer) {
        FlowLayout layout = (FlowLayout)radContainer.getLayout();
        writer.addAttribute("hgap", layout.getHgap());
        writer.addAttribute("vgap", layout.getVgap());
        writer.addAttribute("flow-align", layout.getAlignment());
    }

    @Override
    @NotNull
    public ComponentDropLocation getDropLocation(RadContainer container, Point location) {
        FlowLayout flowLayout = (FlowLayout)container.getLayout();
        FlowDropLocation flowDropLocation = new FlowDropLocation(container, location, flowLayout.getAlignment(), (flowLayout.getHgap() + 1) / 2, (flowLayout.getVgap() + 1) / 2);
        if (flowDropLocation == null) {
            RadFlowLayoutManager.$$$reportNull$$$0(0);
        }
        return flowDropLocation;
    }

    @Override
    public Property[] getContainerProperties(Project project) {
        return new Property[]{ALIGN_PROPERTY, HGapProperty.getInstance(project), VGapProperty.getInstance(project)};
    }

    @Override
    public void createSnapshotLayout(SnapshotContext context, JComponent parent, RadContainer container, LayoutManager layout) {
        FlowLayout flowLayout = (FlowLayout)layout;
        container.setLayout(new FlowLayout(flowLayout.getAlignment(), flowLayout.getHgap(), flowLayout.getVgap()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadFlowLayoutManager", "getDropLocation"));
    }

    private static class MyAlignProperty
    extends Property<RadContainer, Integer> {
        private IntEnumRenderer myRenderer;
        private IntEnumEditor myEditor;
        private IntEnumEditor.Pair[] myPairs;

        public MyAlignProperty() {
            super(null, "Alignment");
        }

        private void initPairs() {
            if (this.myPairs == null) {
                this.myPairs = new IntEnumEditor.Pair[]{new IntEnumEditor.Pair(1, UIDesignerBundle.message("property.center", new Object[0])), new IntEnumEditor.Pair(0, UIDesignerBundle.message("property.left", new Object[0])), new IntEnumEditor.Pair(2, UIDesignerBundle.message("property.right", new Object[0])), new IntEnumEditor.Pair(3, UIDesignerBundle.message("property.leading", new Object[0])), new IntEnumEditor.Pair(4, UIDesignerBundle.message("property.trailing", new Object[0]))};
            }
        }

        @Override
        public Integer getValue(RadContainer component) {
            LayoutManager layout = component.getLayout();
            if (!(layout instanceof FlowLayout)) {
                return null;
            }
            FlowLayout flowLayout = (FlowLayout)layout;
            return flowLayout.getAlignment();
        }

        @Override
        protected void setValueImpl(RadContainer component, Integer value) throws Exception {
            FlowLayout flowLayout = (FlowLayout)component.getLayout();
            flowLayout.setAlignment(value);
        }

        @Override
        @NotNull
        public PropertyRenderer<Integer> getRenderer() {
            if (this.myRenderer == null) {
                this.initPairs();
                this.myRenderer = new IntEnumRenderer(this.myPairs);
            }
            IntEnumRenderer intEnumRenderer = this.myRenderer;
            if (intEnumRenderer == null) {
                MyAlignProperty.$$$reportNull$$$0(0);
            }
            return intEnumRenderer;
        }

        @Override
        @NotNull
        public PropertyEditor<Integer> getEditor() {
            if (this.myEditor == null) {
                this.initPairs();
                this.myEditor = new IntEnumEditor(this.myPairs);
            }
            IntEnumEditor intEnumEditor = this.myEditor;
            if (intEnumEditor == null) {
                MyAlignProperty.$$$reportNull$$$0(1);
            }
            return intEnumEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            LayoutManager layout = component.getLayout();
            if (!(layout instanceof FlowLayout)) {
                return false;
            }
            FlowLayout flowLayout = (FlowLayout)layout;
            return flowLayout.getAlignment() != 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/uiDesigner/radComponents/RadFlowLayoutManager$MyAlignProperty";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

