/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.propertyInspector.properties.HSizePolicyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.SizePolicyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VSizePolicyProperty;
import com.intellij.uiDesigner.radComponents.CustomPropertiesPanel;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GridLayoutColumnProperties
implements CustomPropertiesPanel {
    private JPanel myRootPanel;
    private JCheckBox myWantGrowCheckBox;
    private JLabel myTitleLabel;
    private RadContainer myContainer;
    private boolean myRow;
    private int mySelectedIndex;
    private final List<ChangeListener> myListeners;

    public GridLayoutColumnProperties() {
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myWantGrowCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (RadComponent c : GridLayoutColumnProperties.this.myContainer.getComponents()) {
                    SizePolicyProperty property;
                    if (c.getConstraints().getCell(GridLayoutColumnProperties.this.myRow) != GridLayoutColumnProperties.this.mySelectedIndex) continue;
                    SizePolicyProperty sizePolicyProperty = property = GridLayoutColumnProperties.this.myRow ? VSizePolicyProperty.getInstance(c.getProject()) : HSizePolicyProperty.getInstance(c.getProject());
                    if (GridLayoutColumnProperties.this.myWantGrowCheckBox.isSelected()) {
                        property.setValueEx(c, (Integer)property.getValue(c) | 4);
                        break;
                    }
                    if (((Integer)property.getValue(c) & 4) == 0) continue;
                    property.setValueEx(c, (Integer)property.getValue(c) & 0xFFFFFFFB);
                    break;
                }
                for (ChangeListener listener : GridLayoutColumnProperties.this.myListeners) {
                    listener.stateChanged(new ChangeEvent(this));
                }
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public void showProperties(RadContainer container, boolean isRow, int[] selectedIndices) {
        this.myContainer = container;
        this.myRow = isRow;
        if (selectedIndices.length != 1) {
            this.myTitleLabel.setText(selectedIndices.length + (isRow ? " rows selected" : " columns selected"));
            this.myWantGrowCheckBox.setEnabled(false);
        } else {
            this.mySelectedIndex = selectedIndices[0];
            this.myTitleLabel.setText((isRow ? "Row " : "Column ") + selectedIndices[0]);
            this.myWantGrowCheckBox.setEnabled(true);
            GridLayoutManager layout = (GridLayoutManager)container.getLayout();
            int sizePolicy = layout.getCellSizePolicy(isRow, selectedIndices[0]);
            this.myWantGrowCheckBox.setSelected((sizePolicy & 4) != 0);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("Column Properties");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myWantGrowCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Want Grow");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

