/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ComboBoxPropertyEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ButtonGroupProperty
extends Property<RadComponent, RadButtonGroup> {
    private final LabelPropertyRenderer<RadButtonGroup> myRenderer = new LabelPropertyRenderer<RadButtonGroup>(){

        @Override
        protected void customize(@NotNull RadButtonGroup value) {
            if (value == null) {
                1.$$$reportNull$$$0(0);
            }
            this.setText(value.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/properties/ButtonGroupProperty$1", "customize"));
        }
    };
    private final ComboBoxPropertyEditor<RadButtonGroup> myEditor = new MyPropertyEditor();

    public ButtonGroupProperty() {
        super(null, "Button Group");
    }

    @Override
    public RadButtonGroup getValue(RadComponent component) {
        RadRootContainer rootContainer = (RadRootContainer)FormEditingUtil.getRoot(component);
        return rootContainer == null ? null : (RadButtonGroup)FormEditingUtil.findGroupForComponent(rootContainer, component);
    }

    @Override
    protected void setValueImpl(RadComponent component, RadButtonGroup value) throws Exception {
        RadRootContainer radRootContainer = (RadRootContainer)FormEditingUtil.getRoot(component);
        assert (radRootContainer != null);
        radRootContainer.setGroupForComponent(component, value);
    }

    @Override
    @NotNull
    public PropertyRenderer<RadButtonGroup> getRenderer() {
        LabelPropertyRenderer<RadButtonGroup> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            ButtonGroupProperty.$$$reportNull$$$0(0);
        }
        return labelPropertyRenderer;
    }

    @Override
    public PropertyEditor<RadButtonGroup> getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean isModified(RadComponent component) {
        return this.getValue(component) != null;
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        this.setValueImpl(component, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/ButtonGroupProperty", "getRenderer"));
    }

    private static class MyPropertyEditor
    extends ComboBoxPropertyEditor<RadButtonGroup> {
        private RadRootContainer myRootContainer;
        private RadComponent myComponent;

        public MyPropertyEditor() {
            this.myCbx.setRenderer((ListCellRenderer)new ListCellRendererWrapper<RadButtonGroup>(){

                public void customize(JList list, RadButtonGroup value, int index, boolean selected, boolean hasFocus) {
                    if (value == null) {
                        this.setText(UIDesignerBundle.message("button.group.none", new Object[0]));
                    } else if (value == RadButtonGroup.NEW_GROUP) {
                        this.setText(UIDesignerBundle.message("button.group.new", new Object[0]));
                    } else {
                        this.setText(value.getName());
                    }
                }
            });
            this.myCbx.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && e.getItem() == RadButtonGroup.NEW_GROUP) {
                        String newGroupName = myRootContainer.suggestGroupName();
                        newGroupName = (String)JOptionPane.showInputDialog((Component)myCbx, UIDesignerBundle.message("button.group.name.prompt", new Object[0]), UIDesignerBundle.message("button.group.name.title", new Object[0]), 3, null, null, newGroupName);
                        if (newGroupName != null) {
                            RadButtonGroup group = myRootContainer.createGroup(newGroupName);
                            myRootContainer.setGroupForComponent(myComponent, group);
                            this.updateModel();
                        }
                    }
                }
            });
        }

        @Override
        public JComponent getComponent(RadComponent component, RadButtonGroup value, InplaceContext inplaceContext) {
            this.myComponent = component;
            this.myRootContainer = (RadRootContainer)FormEditingUtil.getRoot(this.myComponent);
            this.updateModel();
            return this.myCbx;
        }

        private void updateModel() {
            RadButtonGroup[] groups = this.myRootContainer.getButtonGroups();
            RadButtonGroup[] allGroups = new RadButtonGroup[groups.length + 2];
            System.arraycopy(groups, 0, allGroups, 1, groups.length);
            allGroups[allGroups.length - 1] = RadButtonGroup.NEW_GROUP;
            this.myCbx.setModel(new DefaultComboBoxModel<RadButtonGroup>(allGroups));
            this.myCbx.setSelectedItem((Object)FormEditingUtil.findGroupForComponent(this.myRootContainer, this.myComponent));
        }
    }
}

