/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class EnumEditor
extends PropertyEditor<Enum> {
    private final JComboBox myCbx;

    public EnumEditor(Class enumClass) {
        this.myCbx = new JComboBox(enumClass.getEnumConstants());
        this.myCbx.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    public Enum getValue() throws Exception {
        return (Enum)this.myCbx.getSelectedItem();
    }

    @Override
    public JComponent getComponent(RadComponent component, Enum value, InplaceContext inplaceContext) {
        if (value == null) {
            return this.myCbx;
        }
        ComboBoxModel model = this.myCbx.getModel();
        for (int i = model.getSize() - 1; i >= 0; --i) {
            if (model.getElementAt(i) != value) continue;
            this.myCbx.setSelectedIndex(i);
            return this.myCbx;
        }
        throw new IllegalArgumentException("unknown value: " + value);
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.myCbx);
        SwingUtilities.updateComponentTreeUI((JComponent)((Object)this.myCbx.getRenderer()));
    }
}

