/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.util.Condition;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.editors.ComboBoxPropertyEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.ComponentRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public class ComponentEditor
extends ComboBoxPropertyEditor<String> {
    private final Class myPropertyType;
    private final Condition<RadComponent> myFilter;
    private String myOldValue;

    public ComponentEditor(Class propertyType, Condition<RadComponent> filter) {
        this.myPropertyType = propertyType;
        this.myFilter = filter;
        this.myCbx.setRenderer((ListCellRenderer)((Object)new ComponentRenderer()));
    }

    @Override
    public JComponent getComponent(RadComponent component, String value, InplaceContext inplaceContext) {
        RadComponent[] components = this.collectFilteredComponents(component);
        this.myCbx.setModel(new DefaultComboBoxModel<RadComponent>(components));
        this.myOldValue = value;
        if (value == null || this.myOldValue.length() == 0) {
            this.myCbx.setSelectedIndex(0);
        } else {
            for (int i = 1; i < components.length; ++i) {
                if (!components[i].getId().equals(value)) continue;
                this.myCbx.setSelectedIndex(i);
                break;
            }
        }
        return this.myCbx;
    }

    protected RadComponent[] collectFilteredComponents(RadComponent component) {
        final ArrayList result = new ArrayList();
        result.add(null);
        RadContainer container = component.getParent();
        while (container.getParent() != null) {
            container = container.getParent();
        }
        FormEditingUtil.iterate(container, new FormEditingUtil.ComponentVisitor(){

            public boolean visit(IComponent component) {
                RadComponent radComponent = (RadComponent)component;
                JComponent delegee = radComponent.getDelegee();
                if (!ComponentEditor.this.myPropertyType.isInstance(delegee)) {
                    return true;
                }
                if (ComponentEditor.this.myFilter == null || ComponentEditor.this.myFilter.value((Object)radComponent)) {
                    result.add(radComponent);
                }
                return true;
            }
        });
        return result.toArray(RadComponent.EMPTY_ARRAY);
    }

    @Override
    public String getValue() throws Exception {
        RadComponent selection = (RadComponent)this.myCbx.getSelectedItem();
        if (selection == null) {
            return this.myOldValue == null ? null : "";
        }
        return selection.getId();
    }
}

