/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.SurroundAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;

public class NoScrollPaneInspection
extends BaseFormInspection {
    public NoScrollPaneInspection() {
        super("NoScrollPane");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = UIDesignerBundle.message("inspection.no.scroll.pane", new Object[0]);
        if (string == null) {
            NoScrollPaneInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void checkComponentProperties(Module module, @NotNull IComponent component, FormErrorCollector collector) {
        if (component == null) {
            NoScrollPaneInspection.$$$reportNull$$$0(1);
        }
        if (FormInspectionUtil.isComponentClass(module, component, Scrollable.class) && !FormInspectionUtil.isComponentClass(module, component, JTextField.class) && !FormInspectionUtil.isComponentClass(module, (IComponent)component.getParentContainer(), JScrollPane.class)) {
            collector.addError(this.getID(), component, null, UIDesignerBundle.message("inspection.no.scroll.pane", new Object[0]), MyQuickFix::new);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/inspections/NoScrollPaneInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/inspections/NoScrollPaneInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkComponentProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyQuickFix
    extends QuickFix {
        MyQuickFix(GuiEditor editor, RadComponent component) {
            super(editor, UIDesignerBundle.message("inspection.no.scroll.pane.quickfix", new Object[0]), component);
        }

        @Override
        public void run() {
            String scrollPane = JScrollPane.class.getName();
            ComponentItem item = Palette.getInstance(this.myEditor.getProject()).getItem(scrollPane);
            SurroundAction action = new SurroundAction(item == null ? JBScrollPane.class.getName() : scrollPane);
            ArrayList<RadComponent> targetList = new ArrayList<RadComponent>(Collections.singletonList(this.myComponent));
            action.actionPerformed(this.myEditor, targetList, null);
        }
    }
}

