/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.GridInsertMode;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Rectangle;

public class GridSpanInsertProcessor {
    private final RadContainer myContainer;
    private final RadAbstractGridLayoutManager myLayoutManager;
    private final int myRow;
    private final int myColumn;
    private GridInsertMode myMode;
    private RadComponent myInsertCellComponent;

    public GridSpanInsertProcessor(RadContainer container, int insertRow, int insertColumn, GridInsertMode mode, ComponentDragObject dragObject) {
        this.myContainer = container;
        this.myLayoutManager = container.getGridLayoutManager();
        this.myRow = insertRow;
        this.myColumn = insertColumn;
        int[] vGridLines = this.myLayoutManager.getVerticalGridLines(container);
        int[] hGridLines = this.myLayoutManager.getHorizontalGridLines(container);
        RadComponent component = RadAbstractGridLayoutManager.getComponentAtGrid(container, insertRow, insertColumn);
        if (component != null) {
            int lastRowIndex;
            int lastColIndex = insertColumn + dragObject.getColSpan(0);
            if (lastColIndex > vGridLines.length - 1) {
                lastColIndex = insertColumn + 1;
            }
            if ((lastRowIndex = insertRow + dragObject.getRowSpan(0)) > hGridLines.length - 1) {
                lastRowIndex = insertRow + 1;
            }
            Rectangle bounds = component.getBounds();
            bounds.translate(-vGridLines[insertColumn], -hGridLines[insertRow]);
            int spaceToRight = vGridLines[lastColIndex] - vGridLines[insertColumn] - (bounds.x + bounds.width);
            int spaceBelow = hGridLines[lastRowIndex] - hGridLines[insertRow] - (bounds.y + bounds.height);
            if (mode == GridInsertMode.RowBefore && bounds.y > 15) {
                this.myMode = GridInsertMode.RowBefore;
                this.myInsertCellComponent = component;
            } else if (mode == GridInsertMode.RowAfter && spaceBelow > 15) {
                this.myMode = GridInsertMode.RowAfter;
            } else if (mode == GridInsertMode.ColumnBefore && bounds.x > 15) {
                this.myMode = GridInsertMode.ColumnBefore;
                this.myInsertCellComponent = component;
            } else if (mode == GridInsertMode.ColumnAfter && spaceToRight > 15) {
                this.myMode = GridInsertMode.ColumnAfter;
            }
        }
    }

    public void doBefore(int newCell) {
        block5: {
            block4: {
                if (this.myMode != GridInsertMode.RowBefore) break block4;
                int oldRow = this.myInsertCellComponent.getConstraints().getRow();
                int columns = this.myLayoutManager.getGridColumnCount(this.myContainer);
                for (int i = 0; i < columns; ++i) {
                    RadComponent component;
                    if (i == this.myColumn || (component = RadAbstractGridLayoutManager.getComponentAtGrid(this.myContainer, oldRow, i)) == null) continue;
                    GridConstraints constraints = component.getConstraints();
                    if (constraints.getRow() == oldRow) {
                        GridConstraints oldConstraints = (GridConstraints)constraints.clone();
                        constraints.setRow(newCell);
                        constraints.setRowSpan(constraints.getRowSpan() + oldRow - newCell);
                        component.fireConstraintsChanged(oldConstraints);
                    }
                    i = constraints.getColumn() + constraints.getColSpan() - 1;
                }
                break block5;
            }
            if (this.myMode != GridInsertMode.ColumnBefore) break block5;
            int oldColumn = this.myInsertCellComponent.getConstraints().getColumn();
            int rows = this.myLayoutManager.getGridRowCount(this.myContainer);
            for (int i = 0; i < rows; ++i) {
                RadComponent component;
                if (i == this.myRow || (component = RadAbstractGridLayoutManager.getComponentAtGrid(this.myContainer, i, oldColumn)) == null) continue;
                GridConstraints constraints = component.getConstraints();
                if (constraints.getColumn() == oldColumn) {
                    GridConstraints oldConstraints = (GridConstraints)constraints.clone();
                    constraints.setColumn(newCell);
                    constraints.setColSpan(constraints.getColSpan() + oldColumn - newCell);
                    component.fireConstraintsChanged(oldConstraints);
                }
                i = constraints.getRow() + constraints.getRowSpan() - 1;
            }
        }
    }

    public void doAfter(int newCell) {
        block5: {
            block4: {
                if (this.myMode != GridInsertMode.RowAfter) break block4;
                int columns = this.myLayoutManager.getGridColumnCount(this.myContainer);
                for (int i = 0; i < columns; ++i) {
                    RadComponent component;
                    if (i == this.myColumn || (component = RadAbstractGridLayoutManager.getComponentAtGrid(this.myContainer, this.myRow, i)) == null) continue;
                    GridConstraints constraints = component.getConstraints();
                    int endRow = constraints.getRow() + constraints.getRowSpan() - 1;
                    if (endRow == this.myRow) {
                        GridConstraints oldConstraints = (GridConstraints)constraints.clone();
                        constraints.setRowSpan(constraints.getRowSpan() + newCell - this.myRow);
                        component.fireConstraintsChanged(oldConstraints);
                    }
                    i = constraints.getColumn() + constraints.getColSpan() - 1;
                }
                break block5;
            }
            if (this.myMode != GridInsertMode.ColumnAfter) break block5;
            int rows = this.myLayoutManager.getGridRowCount(this.myContainer);
            for (int i = 0; i < rows; ++i) {
                RadComponent component;
                if (i == this.myRow || (component = RadAbstractGridLayoutManager.getComponentAtGrid(this.myContainer, i, this.myColumn)) == null) continue;
                GridConstraints constraints = component.getConstraints();
                int endColumn = constraints.getColumn() + constraints.getColSpan() - 1;
                if (endColumn == this.myColumn) {
                    GridConstraints oldConstraints = (GridConstraints)constraints.clone();
                    constraints.setColSpan(constraints.getColSpan() + newCell - this.myColumn);
                    component.fireConstraintsChanged(oldConstraints);
                }
                i = constraints.getRow() + constraints.getRowSpan() - 1;
            }
        }
    }
}

