/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceInForm
implements PsiReference {
    protected final PsiPlainTextFile myFile;
    private final RangeMarker myRangeMarker;

    protected ReferenceInForm(PsiPlainTextFile file, TextRange range) {
        this.myFile = file;
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile.getViewProvider().getVirtualFile());
        this.myRangeMarker = document.createRangeMarker(range);
    }

    @NotNull
    public PsiElement getElement() {
        PsiPlainTextFile psiPlainTextFile = this.myFile;
        if (psiPlainTextFile == null) {
            ReferenceInForm.$$$reportNull$$$0(0);
        }
        return psiPlainTextFile;
    }

    public PsiElement handleElementRename(String newElementName) {
        return this.handleElementRenameBase(newElementName);
    }

    private PsiElement handleElementRenameBase(String newElementName) {
        this.updateRangeText(newElementName);
        return this.myFile;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.create((Segment)this.myRangeMarker);
        if (textRange == null) {
            ReferenceInForm.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeText();
        if (string == null) {
            ReferenceInForm.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void updateRangeText(String text) {
        Document document = this.myRangeMarker.getDocument();
        document.replaceString(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset(), (CharSequence)text);
        PsiDocumentManager.getInstance((Project)this.myFile.getProject()).commitDocument(document);
    }

    public String getRangeText() {
        return this.myRangeMarker.getDocument().getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset()).toString();
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            ReferenceInForm.$$$reportNull$$$0(3);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }

    protected PsiElement handleFileRename(String newElementName, @NonNls String extension, boolean includeExtensionInReference) {
        String extensionInReference;
        String currentName = this.getRangeText();
        String baseName = newElementName.endsWith(extension) ? newElementName.substring(0, newElementName.length() - extension.length()) : newElementName;
        int slashIndex = currentName.lastIndexOf(47);
        String string = extensionInReference = includeExtensionInReference ? extension : "";
        if (slashIndex >= 0) {
            String prefix = currentName.substring(0, slashIndex);
            return this.handleElementRenameBase(prefix + "/" + baseName + extensionInReference);
        }
        return this.handleElementRenameBase(baseName + extensionInReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/uiDesigner/binding/ReferenceInForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

