/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ImportCollector {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private final Map<String, String> mapSimpleNames = new HashMap<String, String>();
    private final Set<String> setNotImportedNames = new HashSet<String>();
    private final Set<String> setFieldNames = new HashSet<String>();
    private final String currentPackageSlash;
    private final String currentPackagePoint;

    public ImportCollector(ClassesProcessor.ClassNode root) {
        String clName = root.classStruct.qualifiedName;
        int index = clName.lastIndexOf(47);
        if (index >= 0) {
            String packageName = clName.substring(0, index);
            this.currentPackageSlash = packageName + '/';
            this.currentPackagePoint = packageName.replace('/', '.');
        } else {
            this.currentPackageSlash = "";
            this.currentPackagePoint = "";
        }
        Map<String, StructClass> classes = DecompilerContext.getStructContext().getClasses();
        StructClass currentClass = root.classStruct;
        while (currentClass != null) {
            for (StructField f : currentClass.getFields()) {
                this.setFieldNames.add(f.getName());
            }
            currentClass = currentClass.superClass != null ? classes.get(currentClass.superClass.getString()) : null;
        }
    }

    public String getShortNameInClassContext(String classToName) {
        String shortName = this.getShortName(classToName);
        if (this.setFieldNames.contains(shortName)) {
            return classToName;
        }
        return shortName;
    }

    public String getShortName(String fullName) {
        return this.getShortName(fullName, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getShortName(String fullName, boolean imported) {
        StructContext context;
        boolean existsDefaultClass;
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(fullName.replace('.', '/'));
        String result = null;
        if (node != null && node.classStruct.isOwn()) {
            result = node.simpleName;
            while (node.parent != null && node.type == 1) {
                result = node.parent.simpleName + '.' + result;
                node = node.parent;
            }
            if (node.type != 0) return result;
            fullName = node.classStruct.qualifiedName;
            fullName = fullName.replace('/', '.');
        } else {
            fullName = fullName.replace('$', '.');
        }
        String shortName = fullName;
        String packageName = "";
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot >= 0) {
            shortName = fullName.substring(lastDot + 1);
            packageName = fullName.substring(0, lastDot);
        }
        boolean bl = existsDefaultClass = (context = DecompilerContext.getStructContext()).getClass(this.currentPackageSlash + shortName) != null && !packageName.equals(this.currentPackagePoint) || context.getClass(shortName) != null && !this.currentPackagePoint.isEmpty();
        if (existsDefaultClass || this.mapSimpleNames.containsKey(shortName) && !packageName.equals(this.mapSimpleNames.get(shortName))) {
            return result == null ? fullName : packageName + "." + result;
        }
        if (this.mapSimpleNames.containsKey(shortName)) return result == null ? shortName : result;
        this.mapSimpleNames.put(shortName, packageName);
        if (imported) return result == null ? shortName : result;
        this.setNotImportedNames.add(shortName);
        return result == null ? shortName : result;
    }

    public int writeImports(TextBuffer buffer) {
        int importLinesWritten = 0;
        List<String> imports = this.packImports();
        for (String s : imports) {
            buffer.append("import ");
            buffer.append(s);
            buffer.append(';');
            buffer.appendLineSeparator();
            ++importLinesWritten;
        }
        return importLinesWritten;
    }

    private List<String> packImports() {
        return this.mapSimpleNames.entrySet().stream().filter(ent -> !this.setNotImportedNames.contains(ent.getKey()) && !((String)ent.getValue()).isEmpty() && !JAVA_LANG_PACKAGE.equals(ent.getValue()) && !((String)ent.getValue()).equals(this.currentPackagePoint)).sorted(Map.Entry.comparingByValue().thenComparing(Map.Entry.comparingByKey())).map(ent -> (String)ent.getValue() + "." + (String)ent.getKey()).collect(Collectors.toList());
    }
}

