/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.rotator;

import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker.GradientPicker;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;

public class RotatorControl
extends GridPane {
    @FXML
    private TextField rotator_textfield;
    @FXML
    private Button rotator_dial;
    @FXML
    private Button rotator_handle;
    @FXML
    private Label rotator_label;
    private final int roundingFactor = 100;
    private final DoubleProperty rotation = new SimpleDoubleProperty();

    public RotatorControl(String text) {
        this.initialize(text);
    }

    public final DoubleProperty rotationProperty() {
        return this.rotation;
    }

    public final double getRotationProperty() {
        return this.rotation.get();
    }

    public final void setRotationProperty(double value) {
        this.rotation.set(value);
    }

    private void initialize(String text) {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(RotatorControl.class.getResource("RotatorControl.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(GradientPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
        assert (this.rotator_label != null);
        this.rotator_label.setText(text);
        this.rotator_dial.setOnAction(event -> event.consume());
        this.rotator_handle.setOnAction(event -> event.consume());
    }

    @FXML
    void rotatorAction(ActionEvent event) {
        double value = Double.valueOf(this.rotator_textfield.getText());
        double rounded = this.round(value, 100);
        this.rotate(rounded);
        this.rotator_textfield.selectAll();
        event.consume();
    }

    @FXML
    void rotatorMousePressed(MouseEvent e) {
        this.rotatorMouseDragged(e);
    }

    @FXML
    void rotatorMouseDragged(MouseEvent e) {
        Parent p = this.rotator_dial.getParent();
        Bounds b = this.rotator_dial.getLayoutBounds();
        Double centerX = b.getMinX() + b.getWidth() / 2.0;
        Double centerY = b.getMinY() + b.getHeight() / 2.0;
        Point2D center = p.localToParent(centerX.doubleValue(), centerY.doubleValue());
        Point2D mouse = p.localToParent(e.getX(), e.getY());
        Double deltaX = mouse.getX() - center.getX();
        Double deltaY = mouse.getY() - center.getY();
        Double radians = Math.atan2(deltaY, deltaX);
        this.rotate(Math.toDegrees(radians));
    }

    private void rotate(Double value) {
        double rounded = this.round(value, 100);
        this.rotation.set(rounded);
        this.rotator_handle.setRotate(rounded);
        this.rotator_textfield.setText(Double.toString(rounded));
    }

    private double round(double value, int roundingFactor) {
        double doubleRounded = Math.round(value * (double)roundingFactor);
        return doubleRounded / (double)roundingFactor;
    }
}

