/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;

public class DoubleTextFieldControl
extends GridPane {
    @FXML
    private Label editor_label;
    @FXML
    private DoubleField editor_textfield;
    private double mini;
    private double maxi;
    private double incDecValue;
    private final DoubleProperty value = new SimpleDoubleProperty();
    private final EffectPickerController effectPickerController;
    private final int roundingFactor = 100;

    public DoubleTextFieldControl(EffectPickerController effectPickerController, String labelString, double min, double max, double initVal, double incDec) {
        this.effectPickerController = effectPickerController;
        this.initialize(labelString, min, max, initVal, incDec);
        this.editor_textfield.focusedProperty().addListener((ov, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                double inputValue = Double.parseDouble(this.editor_textfield.getText());
                this.setValue(inputValue);
                effectPickerController.incrementRevision();
            }
        });
        this.editor_textfield.setOnAction(event -> event.consume());
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public double getValue() {
        return this.value.get();
    }

    @FXML
    void textfieldTyped(KeyEvent e) {
        if (e.getCode() == KeyCode.UP) {
            this.incOrDecValue(this.incDecValue);
            this.effectPickerController.incrementRevision();
        }
        if (e.getCode() == KeyCode.DOWN) {
            this.incOrDecValue(-this.incDecValue);
            this.effectPickerController.incrementRevision();
        }
        if (e.getCode() == KeyCode.ENTER) {
            double inputValue = Double.parseDouble(this.editor_textfield.getText());
            this.setValue(inputValue);
            this.effectPickerController.incrementRevision();
            this.editor_textfield.selectAll();
        }
    }

    private void incOrDecValue(double delta) {
        this.setValue(this.getValue() + delta);
    }

    private void setValue(double d) {
        double val = Utils.clamp(this.mini, d, this.maxi);
        double rounded = EditorUtils.round(val, 100);
        this.value.set(rounded);
        this.editor_textfield.setText(Double.toString(rounded));
    }

    private void initialize(String labelString, double min, double max, double initVal, double incDec) {
        URL layoutURL = DoubleTextFieldControl.class.getResource("NumFieldControl.fxml");
        try (InputStream is = layoutURL.openStream();){
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setLocation(layoutURL);
            Parent p = (Parent)loader.load(is);
            assert (p == this);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        this.editor_label.setText(labelString);
        this.incDecValue = incDec;
        this.mini = min;
        this.maxi = max;
        this.setValue(initVal);
    }
}

