/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ComplexPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.ColorPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.ImagePatternPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.LinearGradientPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.RadialGradientPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;

public class PaintPropertyMetadata
extends ComplexPropertyMetadata<Paint> {
    private final ColorPropertyMetadata colorMetadata;
    private final ImagePatternPropertyMetadata imagePatternMetadata;
    private final LinearGradientPropertyMetadata linearGradientMetadata;
    private final RadialGradientPropertyMetadata radialGradientMetadata;

    public PaintPropertyMetadata(PropertyName name, boolean readWrite, Paint defaultValue, InspectorPath inspectorPath) {
        super(name, Paint.class, readWrite, defaultValue, inspectorPath);
        this.colorMetadata = new ColorPropertyMetadata(name, readWrite, null, inspectorPath);
        this.imagePatternMetadata = new ImagePatternPropertyMetadata(name, readWrite, null, inspectorPath);
        this.linearGradientMetadata = new LinearGradientPropertyMetadata(name, readWrite, null, inspectorPath);
        this.radialGradientMetadata = new RadialGradientPropertyMetadata(name, readWrite, null, inspectorPath);
    }

    @Override
    public Paint makeValueFromString(String string) {
        return this.colorMetadata.makeValueFromString(string);
    }

    @Override
    public boolean canMakeStringFromValue(Paint value) {
        return value instanceof Color;
    }

    @Override
    public String makeStringFromValue(Paint value) {
        assert (value instanceof Color);
        return this.colorMetadata.makeStringFromValue((Color)value);
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(Paint value, FXOMDocument fxomDocument) {
        FXOMInstance result;
        if (value instanceof Color) {
            result = this.colorMetadata.makeFxomInstanceFromValue((Color)value, fxomDocument);
        } else if (value instanceof ImagePattern) {
            result = this.imagePatternMetadata.makeFxomInstanceFromValue((ImagePattern)value, fxomDocument);
        } else if (value instanceof LinearGradient) {
            result = this.linearGradientMetadata.makeFxomInstanceFromValue((LinearGradient)value, fxomDocument);
        } else if (value instanceof RadialGradient) {
            result = this.radialGradientMetadata.makeFxomInstanceFromValue((RadialGradient)value, fxomDocument);
        } else {
            assert (false);
            result = this.colorMetadata.makeFxomInstanceFromValue(Color.BLACK, fxomDocument);
        }
        return result;
    }
}

