/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.glue;

import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueAuxiliary;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueCharacters;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueInstruction;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueLoader;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueNode;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GlueDocument
extends GlueNode {
    private GlueElement rootElement;
    private final List<GlueAuxiliary> header = new ArrayList<GlueAuxiliary>();

    public GlueDocument() {
    }

    public GlueDocument(String xmlText) throws IOException {
        assert (xmlText != null);
        if (!GlueDocument.isEmptyXmlText(xmlText)) {
            GlueLoader loader = new GlueLoader(this);
            loader.load(xmlText);
            this.adjustRootElementIndentation();
        }
    }

    public GlueElement getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(GlueElement newRootElement) {
        if (newRootElement != null && newRootElement.getParent() != null) {
            newRootElement.removeFromParent();
        }
        this.rootElement = newRootElement;
    }

    public List<GlueAuxiliary> getHeader() {
        return this.header;
    }

    public void updateIndent() {
        if (this.rootElement != null) {
            this.rootElement.updateIndent(0);
        }
    }

    public List<GlueInstruction> collectInstructions(String target) {
        ArrayList<GlueInstruction> result = new ArrayList<GlueInstruction>();
        assert (target != null);
        for (GlueAuxiliary auxiliary : this.header) {
            GlueInstruction i;
            if (!(auxiliary instanceof GlueInstruction) || !target.equals((i = (GlueInstruction)auxiliary).getTarget())) continue;
            result.add(i);
        }
        return result;
    }

    public static boolean isEmptyXmlText(String xmlText) {
        assert (xmlText != null);
        return xmlText.trim().isEmpty();
    }

    public String toString() {
        String result;
        if (this.rootElement == null) {
            result = "";
        } else {
            GlueSerializer serializer = new GlueSerializer(this);
            result = serializer.toString();
        }
        return result;
    }

    private void adjustRootElementIndentation() {
        if (this.rootElement != null && this.rootElement.getChildren().isEmpty()) {
            if (this.rootElement.getFront().isEmpty()) {
                this.rootElement.getFront().add(new GlueCharacters(this, GlueCharacters.Type.TEXT, "\n"));
            }
            if (this.rootElement.getTail().isEmpty()) {
                this.rootElement.getTail().add(new GlueCharacters(this, GlueCharacters.Type.TEXT, "\n"));
            }
        }
    }
}

