/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.glue;

import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueAuxiliary;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;

public class GlueCharacters
extends GlueAuxiliary {
    private final Type type;
    private String data;

    public GlueCharacters(GlueDocument document, Type type, String data) {
        super(document);
        this.type = type;
        this.data = data;
    }

    public Type getType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void adjustIndentBy(int delta) {
        StringBuilder newValue = new StringBuilder();
        if (delta > 0) {
            int length = this.data.length();
            for (int i = 0; i < length; ++i) {
                char ch = this.data.charAt(i);
                newValue.append(ch);
                if (ch != '\n') continue;
                for (int n = 0; n < delta; ++n) {
                    newValue.append(' ');
                }
            }
        } else {
            int length = this.data.length();
            for (int i = 0; i < length; ++i) {
                char ch = this.data.charAt(i);
                newValue.append(ch);
                if (ch != '\n') continue;
                while (i + 1 < length && this.data.charAt(i + 1) == ' ' && delta < 0) {
                    ++i;
                    ++delta;
                }
            }
        }
        this.data = newValue.toString();
    }

    public int guessIndent() {
        int result;
        int i;
        int count = this.data.length();
        for (i = 0; i < count && this.data.charAt(i) != '\n'; ++i) {
        }
        if (i < count) {
            ++i;
            result = 0;
            while (i < count && this.data.charAt(i) == ' ') {
                ++result;
                ++i;
            }
        } else {
            result = -1;
        }
        return result;
    }

    public static enum Type {
        TEXT,
        COMMENT;

    }
}

