/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FXOMCollection
extends FXOMObject {
    private final List<FXOMObject> items = new ArrayList<FXOMObject>();
    private Class<?> declaredClass;

    FXOMCollection(FXOMDocument fxomDocument, GlueElement glueElement, Class<?> declaredClass, Object sceneGraphObject, List<FXOMObject> items) {
        super(fxomDocument, glueElement, sceneGraphObject);
        assert (declaredClass != null);
        assert (declaredClass.getSimpleName().equals(glueElement.getTagName()));
        assert (sceneGraphObject instanceof Collection);
        assert (items != null);
        this.declaredClass = declaredClass;
        for (FXOMObject i : items) {
            this.items.add(i);
            i.setParentCollection(this);
        }
    }

    FXOMCollection(FXOMDocument fxomDocument, Class<?> declaredClass) {
        super(fxomDocument, declaredClass.getSimpleName());
        this.declaredClass = declaredClass;
    }

    public Class<?> getDeclaredClass() {
        return this.declaredClass;
    }

    public void setDeclaredClass(Class<?> declaredClass) {
        this.declaredClass = declaredClass;
    }

    public List<FXOMObject> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public List<FXOMObject> getChildObjects() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public FXOMObject searchWithSceneGraphObject(Object sceneGraphObject) {
        FXOMObject result = super.searchWithSceneGraphObject(sceneGraphObject);
        if (result == null) {
            Iterator<FXOMObject> it = this.items.iterator();
            while (result == null && it.hasNext()) {
                FXOMObject item = it.next();
                result = item.searchWithSceneGraphObject(sceneGraphObject);
            }
        }
        return result;
    }

    @Override
    public FXOMObject searchWithFxId(String fxId) {
        FXOMObject result = super.searchWithFxId(fxId);
        if (result == null) {
            Iterator<FXOMObject> it = this.items.iterator();
            while (result == null && it.hasNext()) {
                FXOMObject item = it.next();
                result = item.searchWithFxId(fxId);
            }
        }
        return result;
    }

    @Override
    protected void collectDeclaredClasses(Set<Class<?>> result) {
        assert (result != null);
        result.add(this.declaredClass);
        for (FXOMObject i : this.items) {
            i.collectDeclaredClasses(result);
        }
    }

    @Override
    protected void collectProperties(PropertyName propertyName, List<FXOMProperty> result) {
        assert (propertyName != null);
        assert (result != null);
        for (FXOMObject i : this.items) {
            i.collectProperties(propertyName, result);
        }
    }

    @Override
    protected void collectNullProperties(List<FXOMPropertyT> result) {
        assert (result != null);
        for (FXOMObject i : this.items) {
            i.collectNullProperties(result);
        }
    }

    @Override
    protected void collectPropertiesT(List<FXOMPropertyT> result) {
        assert (result != null);
        for (FXOMObject i : this.items) {
            i.collectPropertiesT(result);
        }
    }

    @Override
    protected void collectReferences(String source, List<FXOMIntrinsic> result) {
        for (FXOMObject i : this.items) {
            i.collectReferences(source, result);
        }
    }

    @Override
    protected void collectReferences(String source, FXOMObject scope, List<FXOMNode> result) {
        if (scope == null || scope != this) {
            for (FXOMObject i : this.items) {
                i.collectReferences(source, scope, result);
            }
        }
    }

    @Override
    protected void collectIncludes(String source, List<FXOMIntrinsic> result) {
        for (FXOMObject i : this.items) {
            i.collectIncludes(source, result);
        }
    }

    @Override
    protected void collectFxIds(Map<String, FXOMObject> result) {
        String fxId = this.getFxId();
        if (fxId != null) {
            result.put(fxId, this);
        }
        for (FXOMObject i : this.items) {
            i.collectFxIds(result);
        }
    }

    @Override
    protected void collectObjectWithSceneGraphObjectClass(Class<?> sceneGraphObjectClass, List<FXOMObject> result) {
        if (this.getSceneGraphObject() != null) {
            if (this.getSceneGraphObject().getClass() == sceneGraphObjectClass) {
                result.add(this);
            }
            for (FXOMObject i : this.items) {
                i.collectObjectWithSceneGraphObjectClass(sceneGraphObjectClass, result);
            }
        }
    }

    @Override
    protected void collectEventHandlers(List<FXOMPropertyT> result) {
        if (this.getSceneGraphObject() != null) {
            for (FXOMObject i : this.items) {
                i.collectEventHandlers(result);
            }
        }
    }

    @Override
    protected void changeFxomDocument(FXOMDocument destination) {
        super.changeFxomDocument(destination);
        for (FXOMObject i : this.items) {
            i.changeFxomDocument(destination);
        }
    }

    @Override
    public void documentLocationWillChange(URL newLocation) {
        for (FXOMObject i : this.items) {
            i.documentLocationWillChange(newLocation);
        }
    }

    void addValue(int index, FXOMObject item) {
        assert (item != null);
        assert (item.getParentCollection() == this);
        assert (!this.items.contains(item));
        if (index == -1) {
            this.items.add(item);
        } else {
            this.items.add(index, item);
        }
    }

    void removeValue(FXOMObject item) {
        assert (item != null);
        assert (item.getParentProperty() == null);
        assert (this.items.contains(item));
        this.items.remove(item);
    }
}

