/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class KeyCombinationPopupEditor
extends PopupEditor {
    @FXML
    StackPane mainKeySp;
    @FXML
    Button clearAllBt;
    private GridPane gridPane;
    private static final int NB_MODIFIERS_MAX = 5;
    private final ArrayList<ModifierRow> modifierRows = new ArrayList();
    private KeyCombination.ModifierValue alt;
    private KeyCombination.ModifierValue control;
    private KeyCombination.ModifierValue meta;
    private KeyCombination.ModifierValue shift;
    private KeyCombination.ModifierValue shortcut;
    private MainKey mainKey;
    private EditorController editorController;
    private final KeyCombination.Modifier[] keyCombinationModifiers = new KeyCombination.Modifier[]{KeyCombination.ALT_ANY, KeyCombination.ALT_DOWN, KeyCombination.CONTROL_ANY, KeyCombination.CONTROL_DOWN, KeyCombination.META_ANY, KeyCombination.META_DOWN, KeyCombination.SHIFT_ANY, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_ANY, KeyCombination.SHORTCUT_DOWN};

    public KeyCombinationPopupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super(propMeta, selectedClasses);
        this.initialize(editorController);
    }

    private void initialize(EditorController editorController) {
        this.editorController = editorController;
    }

    @Override
    public void initializePopupContent() {
        Parent root = EditorUtils.loadPopupFxml("KeyCombinationPopupEditor.fxml", this);
        assert (root instanceof GridPane);
        this.gridPane = (GridPane)root;
        List<Field> keyCodes = Arrays.asList(KeyCode.class.getFields());
        ArrayList<String> keyCodesStr = new ArrayList<String>();
        for (Field keyCode : keyCodes) {
            keyCodesStr.add(keyCode.getName());
        }
        this.mainKey = new MainKey(keyCodesStr, this.editorController);
        this.mainKeySp.getChildren().add((Object)this.mainKey.getNode());
        this.clearAllBt.setText(I18N.getString("inspector.keycombination.clear"));
        this.clearAllBt.setOnAction(t -> {
            this.resetState();
            this.buildUI();
            this.commit(null);
        });
        this.buildUI();
    }

    @Override
    public String getPreviewString(Object value) {
        if (value == null) {
            return I18N.getString("inspector.keycombination.null");
        }
        assert (value instanceof KeyCombination);
        KeyCombination keyCombinationVal = (KeyCombination)value;
        String valueAsString = this.isIndeterminate() ? "-" : keyCombinationVal.toString();
        return valueAsString;
    }

    @Override
    public void setPopupContentValue(Object value) {
        if (value != null) {
            this.resetState();
            this.resetUI();
            assert (value instanceof KeyCombination);
            this.buildContent((KeyCombination)value);
        } else {
            this.resetState();
            this.buildUI();
        }
    }

    @Override
    public Node getPopupContentNode() {
        return this.gridPane;
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super.reset(propMeta, selectedClasses);
        this.editorController = editorController;
    }

    private void resetState() {
        this.modifierRows.clear();
        this.mainKey.setKeyCode(null);
    }

    private void resetUI() {
        this.gridPane.getChildren().clear();
        this.gridPane.getRowConstraints().clear();
    }

    private void buildContent(KeyCombination keyCombination) {
        assert (keyCombination != null);
        this.modifierRows.clear();
        KeyCombination.Modifier modifier1 = null;
        this.alt = keyCombination.getAlt();
        if (this.alt != KeyCombination.ModifierValue.UP) {
            if (this.alt == KeyCombination.ModifierValue.DOWN) {
                modifier1 = KeyCombination.ALT_DOWN;
            } else if (this.alt == KeyCombination.ModifierValue.ANY) {
                modifier1 = KeyCombination.ALT_ANY;
            }
            this.createModifierRow(modifier1);
        }
        KeyCombination.Modifier modifier2 = null;
        this.control = keyCombination.getControl();
        if (this.control != KeyCombination.ModifierValue.UP) {
            if (this.control == KeyCombination.ModifierValue.DOWN) {
                modifier2 = KeyCombination.CONTROL_DOWN;
            } else if (this.control == KeyCombination.ModifierValue.ANY) {
                modifier2 = KeyCombination.CONTROL_ANY;
            }
            this.createModifierRow(modifier2);
        }
        KeyCombination.Modifier modifier3 = null;
        this.meta = keyCombination.getMeta();
        if (this.meta != KeyCombination.ModifierValue.UP) {
            if (this.meta == KeyCombination.ModifierValue.DOWN) {
                modifier3 = KeyCombination.META_DOWN;
            } else if (this.meta == KeyCombination.ModifierValue.ANY) {
                modifier3 = KeyCombination.META_ANY;
            }
            this.createModifierRow(modifier3);
        }
        KeyCombination.Modifier modifier4 = null;
        this.shift = keyCombination.getShift();
        if (this.shift != KeyCombination.ModifierValue.UP) {
            if (this.shift == KeyCombination.ModifierValue.DOWN) {
                modifier4 = KeyCombination.SHIFT_DOWN;
            } else if (this.shift == KeyCombination.ModifierValue.ANY) {
                modifier4 = KeyCombination.SHIFT_ANY;
            }
            this.createModifierRow(modifier4);
        }
        KeyCombination.Modifier modifier5 = null;
        this.shortcut = keyCombination.getShortcut();
        if (this.shortcut != KeyCombination.ModifierValue.UP) {
            if (this.shortcut == KeyCombination.ModifierValue.DOWN) {
                modifier5 = KeyCombination.SHORTCUT_DOWN;
            } else if (this.shortcut == KeyCombination.ModifierValue.ANY) {
                modifier5 = KeyCombination.SHORTCUT_ANY;
            }
            this.createModifierRow(modifier5);
        }
        KeyCode keyCode = null;
        if (keyCombination instanceof KeyCodeCombination) {
            keyCode = ((KeyCodeCombination)keyCombination).getCode();
        } else if (keyCombination instanceof KeyCharacterCombination) {
            keyCode = KeyCode.getKeyCode((String)((KeyCharacterCombination)keyCombination).getCharacter());
        }
        this.mainKey.setKeyCode(keyCode);
        this.buildUI();
        this.commit(keyCombination);
    }

    private void commit(KeyCombination keyCombination) {
        this.commitValue(keyCombination);
    }

    private KeyCombination createKeyCombination() {
        if (this.mainKey.isEmpty()) {
            return null;
        }
        KeyCodeCombination keyComb = null;
        ArrayList<KeyCombination.Modifier> modifiers = new ArrayList<KeyCombination.Modifier>();
        for (ModifierRow modifier : this.modifierRows) {
            if (modifier.isEmpty()) continue;
            if (modifiers.contains(modifier.getModifier())) {
                return null;
            }
            modifiers.add(modifier.getModifier());
        }
        if (modifiers.isEmpty()) {
            return null;
        }
        try {
            keyComb = new KeyCodeCombination(this.mainKey.getKeyCode(), modifiers.toArray(new KeyCombination.Modifier[1]));
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            System.out.println("Invalid key combination" + ex);
        }
        catch (RuntimeException ex) {
            System.out.println(ex.getMessage() + ex);
        }
        return keyComb;
    }

    private List<KeyCombination.Modifier> getModifierConstants() {
        ArrayList<KeyCombination.Modifier> mods = new ArrayList<KeyCombination.Modifier>();
        for (KeyCombination.Modifier modifier : this.keyCombinationModifiers) {
            boolean alreadyUsed = false;
            for (ModifierRow row : this.modifierRows) {
                if (row.isEmpty() || !row.getModifier().getKey().equals((Object)modifier.getKey())) continue;
                alreadyUsed = true;
                break;
            }
            if (alreadyUsed) continue;
            mods.add(modifier);
        }
        mods.add(null);
        Collections.sort(mods, new ModifierComparator());
        return mods;
    }

    private ChoiceBox<KeyCombination.Modifier> createModifierChoiceBox(KeyCombination.Modifier modifier) {
        ChoiceBox modifierChoiceBox = new ChoiceBox();
        EditorUtils.makeWidthStretchable((Node)modifierChoiceBox);
        modifierChoiceBox.setConverter((StringConverter)new ModifierConverter());
        modifierChoiceBox.getItems().setAll(this.getModifierConstants());
        if (modifier != null) {
            modifierChoiceBox.getSelectionModel().select((Object)modifier);
        }
        modifierChoiceBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            KeyCombination kc;
            if (!this.mainKey.isEmpty() && (kc = this.createKeyCombination()) != null) {
                this.commit(kc);
            }
            this.buildUI();
        });
        modifierChoiceBox.addEventHandler(ActionEvent.ACTION, event -> event.consume());
        return modifierChoiceBox;
    }

    private void buildUI() {
        boolean bl;
        this.resetUI();
        ArrayList<ModifierRow> emptyRows = new ArrayList<ModifierRow>();
        for (ModifierRow modifierRow : this.modifierRows) {
            if (!modifierRow.isEmpty()) continue;
            emptyRows.add(modifierRow);
        }
        this.modifierRows.removeAll(emptyRows);
        int lineIndex = 0;
        for (ModifierRow row : this.modifierRows) {
            this.addModifierRow(row, lineIndex);
            ++lineIndex;
        }
        boolean bl2 = false;
        if (this.modifierRows.size() < 5) {
            bl = this.addEmptyModifierIfNeeded();
        }
        if (bl) {
            ++lineIndex;
        }
        Label mainKeyLabel = new Label(I18N.getString("inspector.keycombination.mainkey"));
        this.gridPane.add((Node)mainKeyLabel, 0, lineIndex);
        this.gridPane.add(this.mainKey.getNode(), 1, lineIndex);
        this.gridPane.add((Node)this.clearAllBt, 1, ++lineIndex);
    }

    private boolean addEmptyModifierIfNeeded() {
        for (ModifierRow row : this.modifierRows) {
            if (!row.isEmpty()) continue;
            return false;
        }
        this.addModifierRow(this.createModifierRow(null), this.modifierRows.size() - 1);
        return true;
    }

    private void addModifierRow(ModifierRow row, int lineIndex) {
        row.getLabel().setText(I18N.getString("inspector.keycombination.modifier") + " " + (lineIndex + 1));
        this.gridPane.add((Node)row.getLabel(), 0, lineIndex);
        this.gridPane.add(row.getChoiceBox(), 1, lineIndex);
    }

    private ModifierRow createModifierRow(KeyCombination.Modifier modifier) {
        ChoiceBox<KeyCombination.Modifier> choiceBox = this.createModifierChoiceBox(modifier);
        ModifierRow row = new ModifierRow(choiceBox);
        this.modifierRows.add(row);
        return row;
    }

    private static void commitOnFocusLost(AutoSuggestEditor autoSuggestEditor) {
        autoSuggestEditor.getTextField().focusedProperty().addListener((ov, oldVal, newVal) -> {
            if (!newVal.booleanValue()) {
                autoSuggestEditor.getCommitListener().handle(null);
            }
        });
    }

    private static class ModifierConverter
    extends StringConverter<KeyCombination.Modifier> {
        private ModifierConverter() {
        }

        public String toString(KeyCombination.Modifier object) {
            if (object == null) {
                return I18N.getString("inspector.keycombination.none");
            }
            return object.getKey() + "_" + object.getValue();
        }

        public KeyCombination.Modifier fromString(String string) {
            if (string.equals(I18N.getString("inspector.keycombination.none"))) {
                return null;
            }
            if (string.startsWith(KeyCode.ALT.getName())) {
                if (string.endsWith(KeyCombination.ModifierValue.DOWN.name())) {
                    return KeyCombination.ALT_DOWN;
                }
                if (string.endsWith(KeyCombination.ModifierValue.ANY.name())) {
                    return KeyCombination.ALT_ANY;
                }
            }
            if (string.startsWith(KeyCode.CONTROL.getName())) {
                if (string.endsWith(KeyCombination.ModifierValue.DOWN.name())) {
                    return KeyCombination.CONTROL_DOWN;
                }
                if (string.endsWith(KeyCombination.ModifierValue.ANY.name())) {
                    return KeyCombination.CONTROL_ANY;
                }
            }
            if (string.startsWith(KeyCode.META.getName())) {
                if (string.endsWith(KeyCombination.ModifierValue.DOWN.name())) {
                    return KeyCombination.META_DOWN;
                }
                if (string.endsWith(KeyCombination.ModifierValue.ANY.name())) {
                    return KeyCombination.META_ANY;
                }
            }
            if (string.startsWith(KeyCode.SHIFT.getName())) {
                if (string.endsWith(KeyCombination.ModifierValue.DOWN.name())) {
                    return KeyCombination.SHIFT_DOWN;
                }
                if (string.endsWith(KeyCombination.ModifierValue.ANY.name())) {
                    return KeyCombination.SHIFT_ANY;
                }
            }
            if (string.startsWith(KeyCode.SHORTCUT.getName())) {
                if (string.endsWith(KeyCombination.ModifierValue.DOWN.name())) {
                    return KeyCombination.SHORTCUT_DOWN;
                }
                if (string.endsWith(KeyCombination.ModifierValue.ANY.name())) {
                    return KeyCombination.SHORTCUT_ANY;
                }
            }
            return null;
        }
    }

    private static class ModifierRow {
        private Label label = new Label();
        private ChoiceBox<KeyCombination.Modifier> choiceBox;

        public ModifierRow(ChoiceBox<KeyCombination.Modifier> choiceBox) {
            this.choiceBox = choiceBox;
        }

        public Label getLabel() {
            return this.label;
        }

        public void setLabel(Label label) {
            this.label = label;
        }

        public ChoiceBox<KeyCombination.Modifier> getChoiceBox() {
            return this.choiceBox;
        }

        public void setChoiceBox(ChoiceBox<KeyCombination.Modifier> choiceBox) {
            this.choiceBox = choiceBox;
        }

        public KeyCombination.Modifier getModifier() {
            return (KeyCombination.Modifier)this.choiceBox.getSelectionModel().getSelectedItem();
        }

        public boolean isEmpty() {
            return this.getModifier() == null;
        }
    }

    private class MainKey
    extends AutoSuggestEditor {
        private EditorController editorController;
        String mainKey;

        public MainKey(List<String> suggestedKeys, EditorController editorController) {
            super("", null, suggestedKeys);
            this.mainKey = null;
            this.initialize(editorController);
        }

        private void initialize(EditorController editorController) {
            this.editorController = editorController;
            EventHandler onActionListener = t -> {
                KeyCombination kc;
                if (Objects.equals(this.mainKey, this.getTextField().getText())) {
                    return;
                }
                this.mainKey = this.getTextField().getText();
                if (!this.mainKey.isEmpty() && (kc = KeyCombinationPopupEditor.this.createKeyCombination()) != null) {
                    KeyCombinationPopupEditor.this.commit(kc);
                }
            };
            this.setTextEditorBehavior(this, (Control)this.getTextField(), (EventHandler<ActionEvent>)onActionListener);
            KeyCombinationPopupEditor.commitOnFocusLost(this);
        }

        public Node getNode() {
            return this.getValueEditor();
        }

        public void setKeyCode(KeyCode keyCode) {
            this.setValue(keyCode != null ? keyCode.toString() : "");
        }

        public KeyCode getKeyCode() {
            String valStr = this.getTextField().getText();
            if (valStr.isEmpty()) {
                return null;
            }
            valStr = valStr.toUpperCase(Locale.ROOT);
            KeyCode keyCode = null;
            try {
                keyCode = KeyCode.valueOf((String)valStr);
            }
            catch (Exception ex) {
                this.editorController.getMessageLog().logWarningMessage("inspector.keycombination.invalidkeycode", valStr);
            }
            return keyCode;
        }

        public boolean isEmpty() {
            return this.getKeyCode() == null;
        }
    }

    private static class ModifierComparator
    implements Comparator<KeyCombination.Modifier> {
        private ModifierComparator() {
        }

        @Override
        public int compare(KeyCombination.Modifier o1, KeyCombination.Modifier o2) {
            if (o1 == null || o2 == null) {
                return -1;
            }
            String str1 = o1.getKey().toString() + o1.getValue().toString();
            String str2 = o2.getKey().toString() + o2.getValue().toString();
            return str1.compareTo(str2);
        }
    }
}

