/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMFxIdIndex;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;

public class FxIdEditor
extends AutoSuggestEditor {
    private static final String PROPERTY_NAME = "fx:id";
    private static final String DEFAULT_VALUE = null;
    private EditorController editorController;

    public FxIdEditor(List<String> suggestedFxIds, EditorController editorController) {
        super(PROPERTY_NAME, DEFAULT_VALUE, suggestedFxIds);
        this.initialize(editorController);
    }

    private void initialize(EditorController editorController) {
        this.editorController = editorController;
        EventHandler onActionListener = event -> {
            if (this.isHandlingError()) {
                return;
            }
            String value = this.textField.getText();
            if (value != null && !value.isEmpty()) {
                if (!JavaLanguage.isIdentifier(value)) {
                    this.handleInvalidValue(value);
                    return;
                }
                if (this.isValueChanged(value)) {
                    if (this.getFxIdsInUse().contains(value)) {
                        editorController.getMessageLog().logWarningMessage("log.warning.duplicate.fxid", value);
                    } else if (this.getControllerClass() != null && !this.getSuggestedList().contains(value)) {
                        editorController.getMessageLog().logWarningMessage("log.warning.no.injectable.fxid", value);
                    }
                }
            }
            this.userUpdateValueProperty(value == null || value.isEmpty() ? null : value);
            this.textField.selectAll();
        };
        this.setTextEditorBehavior(this, (Control)this.textField, (EventHandler<ActionEvent>)onActionListener);
    }

    public void reset(List<String> suggestedFxIds, EditorController editorController) {
        this.reset(PROPERTY_NAME, DEFAULT_VALUE, suggestedFxIds);
        this.editorController = editorController;
    }

    private List<String> getFxIdsInUse() {
        FXOMFxIdIndex fxomIndex = new FXOMFxIdIndex(this.editorController.getFxomDocument());
        return new ArrayList<String>(fxomIndex.getFxIds().keySet());
    }

    private String getControllerClass() {
        return this.editorController.getFxomDocument().getFxomRoot().getFxController();
    }
}

