/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.layout.StackPane;

public class BoundedDoubleEditor
extends AutoSuggestEditor {
    @FXML
    private Slider slider;
    @FXML
    private StackPane textSp;
    private Parent root = null;
    private Map<String, Object> constants;
    private double min = 0.0;
    private double max = 100.0;
    private boolean minMaxForSliderOnly = false;
    private int roundingFactor = 1;
    private boolean updateFromTextField = false;
    private boolean updateFromSlider = false;

    public BoundedDoubleEditor(String name, String defaultValue, List<String> suggestedList) {
        this(name, defaultValue, suggestedList, null, null, false);
    }

    public BoundedDoubleEditor(String name, String defaultValue, List<String> suggestedList, Double min, Double max, boolean minMaxForSliderOnly) {
        super(name, defaultValue, suggestedList, AutoSuggestEditor.Type.DOUBLE);
        if (min != null) {
            this.min = min;
        }
        if (max != null) {
            this.max = max;
        }
        this.minMaxForSliderOnly = minMaxForSliderOnly;
        this.constants = new TreeMap<String, Object>();
        this.initialize();
    }

    public BoundedDoubleEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Set<FXOMInstance> selectedInstances, Map<String, Object> constantsMap) {
        super(propMeta, selectedClasses, new ArrayList<String>(constantsMap.keySet()), AutoSuggestEditor.Type.DOUBLE);
        this.constants = constantsMap;
        this.handleSpecificCases(propMeta, selectedInstances);
        this.initialize();
    }

    private void initialize() {
        this.root = EditorUtils.loadFxml("BoundedDoubleEditor.fxml", (Object)this);
        EventHandler onActionListener = event -> {
            if (this.isHandlingError()) {
                return;
            }
            if (this.isUpdateFromModel() || this.updateFromSlider) {
                return;
            }
            Object value = this.getValue();
            if (!(this.getPropertyMeta() == null || value != null && ((DoublePropertyMetadata)this.getPropertyMeta()).isValidValue((Double)value))) {
                this.handleInvalidValue(this.getTextField().getText());
            }
            assert (value instanceof Double);
            double valDouble = (Double)value;
            boolean isConstant = this.constants.get(this.getTextField().getText().toUpperCase(Locale.ROOT)) != null;
            for (Map.Entry<String, Object> entry : this.constants.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                isConstant = true;
                break;
            }
            if (!this.minMaxForSliderOnly && !isConstant && (valDouble < this.min || valDouble > this.max)) {
                if (valDouble < this.min) {
                    valDouble = this.min;
                } else if (valDouble > this.max) {
                    valDouble = this.max;
                }
                this.getTextField().setText(EditorUtils.valAsStr(valDouble));
            }
            this.getTextField().selectAll();
            this.updateFromTextField = true;
            this.slider.setValue(valDouble);
            this.updateFromTextField = false;
            this.userUpdateValueProperty(valDouble);
        };
        this.setNumericEditorBehavior(this, (Control)this.getTextField(), (EventHandler<ActionEvent>)onActionListener, false);
        this.configureSlider(this.getPropertyMeta());
        this.slider.valueProperty().addListener(valueModel -> {
            if (this.isUpdateFromModel() || this.updateFromTextField) {
                return;
            }
            double value = EditorUtils.round(this.slider.getValue(), this.roundingFactor);
            this.updateFromSlider = true;
            this.getTextField().setText(EditorUtils.valAsStr(value));
            this.updateFromSlider = false;
            this.userUpdateTransientValueProperty(value);
        });
        this.slider.pressedProperty().addListener(valueModel -> {
            if (!this.slider.isPressed()) {
                double value = EditorUtils.round(this.slider.getValue(), this.roundingFactor);
                this.userUpdateValueProperty(value);
            }
        });
        this.textSp.getChildren().add((Object)super.getRoot());
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        String val = this.getTextField().getText();
        if (val.isEmpty()) {
            val = "0";
            this.getTextField().setText(val);
            return Double.valueOf(val);
        }
        Object constantValue = this.constants.get(val.toUpperCase(Locale.ROOT));
        if (constantValue != null) {
            val = EditorUtils.valAsStr(constantValue);
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        assert (value instanceof Double);
        this.slider.setValue(((Double)value).doubleValue());
        for (Map.Entry<String, Object> entry : this.constants.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            value = entry.getKey();
        }
        this.getTextField().setText(EditorUtils.valAsStr(value));
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Set<FXOMInstance> selectedInstances, Map<String, Object> constants) {
        super.reset(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()));
        this.constants = constants;
        this.handleSpecificCases(propMeta, selectedInstances);
        this.configureSlider(propMeta);
    }

    @Override
    protected void valueIsIndeterminate() {
        BoundedDoubleEditor.handleIndeterminate((Node)this.getTextField());
    }

    private void configureSlider(ValuePropertyMetadata propMeta) {
        if (propMeta != null) {
            assert (propMeta instanceof DoublePropertyMetadata);
            DoublePropertyMetadata doublePropMeta = (DoublePropertyMetadata)propMeta;
            DoublePropertyMetadata.DoubleKind kind = doublePropMeta.getKind();
            if (kind == DoublePropertyMetadata.DoubleKind.OPACITY || kind == DoublePropertyMetadata.DoubleKind.PROGRESS) {
                this.min = 0.0;
                this.max = 1.0;
            }
            this.roundingFactor = this.max <= 1.0 ? 100 : (this.max <= 10.0 ? 10 : 1);
        }
        this.slider.setMin(this.min);
        this.slider.setMax(this.max);
        this.slider.setBlockIncrement((this.max - this.min) / 20.0);
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.getTextField().requestFocus());
    }

    private void handleSpecificCases(ValuePropertyMetadata propMeta, Set<FXOMInstance> selectedInstances) {
        String[] scrollBarPropsArray = new String[]{"hvalue", "vvalue"};
        String[] scrollBarHprops = new String[]{"hmin", "hmax"};
        String[] scrollBarVprops = new String[]{"vmin", "vmax"};
        List<String> scrollBarProps = Arrays.asList(scrollBarPropsArray);
        if (!scrollBarProps.contains(propMeta.getName().toString())) {
            return;
        }
        String[] minMaxProps = propMeta.getName().toString().equals("hvalue") ? scrollBarHprops : scrollBarVprops;
        for (String minMaxProp : minMaxProps) {
            Object propValue = null;
            boolean different = false;
            for (FXOMInstance instance : selectedInstances) {
                Object valueCurr = Metadata.getMetadata().queryValueProperty(instance, new PropertyName(minMaxProp)).getValueInSceneGraphObject(instance);
                if (propValue != null && valueCurr != propValue) {
                    different = true;
                    break;
                }
                propValue = valueCurr;
            }
            if (different) continue;
            assert (propValue instanceof Double);
            if (minMaxProp.contains("min")) {
                this.min = (Double)propValue;
                continue;
            }
            this.max = (Double)propValue;
        }
    }
}

