/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.util;

import javafx.geometry.Point2D;

public class LineEquation {
    private final double x0;
    private final double y0;
    private final double x1;
    private final double y1;
    private final double distance;

    public LineEquation(double x0, double y0, double x1, double y1) {
        assert (x0 != x1 || y0 != y1);
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        double dx = x1 - x0;
        double dy = y1 - y0;
        this.distance = Math.sqrt(dx * dx + dy * dy);
    }

    public LineEquation(Point2D p0, Point2D p1) {
        this(p0.getX(), p0.getY(), p1.getX(), p1.getY());
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean isValid() {
        return this.distance > 0.0;
    }

    public Point2D pointAtOffset(double offset) {
        return this.pointAtP(this.offsetToP(offset));
    }

    public double offsetAtPoint(double x, double y) {
        double dx1 = x - this.x0;
        double dy1 = y - this.y0;
        double dx2 = (this.x1 - this.x0) / this.distance;
        double dy2 = (this.y1 - this.y0) / this.distance;
        double result = dx1 * dx2 + dy1 * dy2;
        return result;
    }

    public Point2D pointAtP(double p) {
        assert (this.isValid());
        double x = this.x0 + p * (this.x1 - this.x0);
        double y = this.y0 + p * (this.y1 - this.y0);
        return new Point2D(x, y);
    }

    public double offsetToP(double offset) {
        assert (this.isValid());
        return offset / this.distance;
    }

    public double pToOffset(double p) {
        assert (this.isValid());
        return p * this.distance;
    }
}

