/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPaneHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.GridPaneColumnResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ColumnConstraintsListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public class ResizeColumnGesture
extends AbstractMouseGesture {
    private static final PropertyName columnConstraintsName = new PropertyName("columnConstraints");
    private static final ValuePropertyMetadata columnConstraintsMeta = new ColumnConstraintsListPropertyMetadata(columnConstraintsName, true, Collections.emptyList(), InspectorPath.UNUSED);
    private final GridPaneHandles gridPaneHandles;
    private final FXOMInstance fxomInstance;
    private final int columnIndex;
    private final GridPane gridPane;
    private GridPaneColumnResizer resizer;

    public ResizeColumnGesture(GridPaneHandles gridPaneHandles, int columnIndex) {
        super(gridPaneHandles.getContentPanelController());
        assert (columnIndex >= 0);
        this.gridPaneHandles = gridPaneHandles;
        this.fxomInstance = gridPaneHandles.getFxomInstance();
        this.gridPane = (GridPane)this.fxomInstance.getSceneGraphObject();
        this.columnIndex = columnIndex;
        assert (this.columnIndex < Deprecation.getGridPaneColumnCount(this.gridPane));
    }

    @Override
    protected void mousePressed() {
    }

    @Override
    protected void mouseDragStarted() {
        assert (this.resizer == null);
        this.resizer = new GridPaneColumnResizer(this.gridPane, this.columnIndex);
        this.mouseDragged();
    }

    @Override
    protected void mouseDragged() {
        assert (this.resizer != null);
        double startSceneX = this.getMousePressedEvent().getSceneX();
        double startSceneY = this.getMousePressedEvent().getSceneY();
        double currentSceneX = this.getLastMouseEvent().getSceneX();
        double currentSceneY = this.getLastMouseEvent().getSceneY();
        Point2D start = this.gridPane.sceneToLocal(startSceneX, startSceneY, true);
        Point2D current = this.gridPane.sceneToLocal(currentSceneX, currentSceneY, true);
        double dx = current.getX() - start.getX();
        this.resizer.updateWidth(dx);
        this.gridPane.layout();
        this.gridPaneHandles.layoutDecoration();
    }

    @Override
    protected void mouseDragEnded() {
        assert (this.resizer != null);
        List<ColumnConstraints> newConstraints = this.cloneColumnConstraintsList(this.gridPane);
        this.userDidCancel();
        EditorController editorController = this.contentPanelController.getEditorController();
        ModifyObjectJob j = new ModifyObjectJob(this.fxomInstance, columnConstraintsMeta, newConstraints, editorController, I18N.getString("label.action.edit.resize.column"));
        editorController.getJobManager().push(j);
        this.gridPaneHandles.layoutDecoration();
        this.resizer = null;
    }

    @Override
    protected void mouseReleased() {
    }

    @Override
    protected void keyEvent(KeyEvent e) {
    }

    @Override
    protected void userDidCancel() {
        this.resizer.revertToOriginalSize();
        this.gridPane.layout();
    }

    private List<ColumnConstraints> cloneColumnConstraintsList(GridPane gridPane) {
        ArrayList<ColumnConstraints> result = new ArrayList<ColumnConstraints>();
        for (ColumnConstraints cc : gridPane.getColumnConstraints()) {
            result.add(this.cloneColumnConstraints(cc));
        }
        return result;
    }

    private ColumnConstraints cloneColumnConstraints(ColumnConstraints cc) {
        ColumnConstraints result = new ColumnConstraints();
        result.setFillWidth(cc.isFillWidth());
        result.setHalignment(cc.getHalignment());
        result.setHgrow(cc.getHgrow());
        result.setMaxWidth(cc.getMaxWidth());
        result.setMinWidth(cc.getMinWidth());
        result.setPercentWidth(cc.getPercentWidth());
        result.setPrefWidth(cc.getPrefWidth());
        return result;
    }
}

