/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.shape.Arc;

public class ArcResizer
extends AbstractResizer<Arc> {
    private final double originalRadiusX;
    private final double originalRadiusY;
    private final Bounds canonicalBounds;
    private final PropertyName radiusXName = new PropertyName("radiusX");
    private final PropertyName radiusYName = new PropertyName("radiusY");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public ArcResizer(Arc sceneGraphObject) {
        super(sceneGraphObject);
        this.originalRadiusX = sceneGraphObject.getRadiusX();
        this.originalRadiusY = sceneGraphObject.getRadiusY();
        this.canonicalBounds = this.computeCanonicalBounds();
        this.propertyNames.add(this.radiusXName);
        this.propertyNames.add(this.radiusYName);
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        double radiusX = Math.round(this.computeRadiusXForWidth(width));
        double radiusY = Math.round(this.computeRadiusYForHeight(height));
        double minX = this.canonicalBounds.getMinX() * radiusX;
        double maxX = this.canonicalBounds.getMaxX() * radiusX;
        double minY = this.canonicalBounds.getMinY() * radiusY;
        double maxY = this.canonicalBounds.getMaxY() * radiusY;
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.FREE;
    }

    @Override
    public void changeWidth(double width) {
        double radiusX = Math.round(this.computeRadiusXForWidth(width));
        ((Arc)this.sceneGraphObject).setRadiusX(radiusX);
    }

    @Override
    public void changeHeight(double height) {
        double radiusY = Math.round(this.computeRadiusYForHeight(height));
        ((Arc)this.sceneGraphObject).setRadiusY(radiusY);
    }

    @Override
    public void revertToOriginalSize() {
        ((Arc)this.sceneGraphObject).setRadiusX(this.originalRadiusX);
        ((Arc)this.sceneGraphObject).setRadiusY(this.originalRadiusY);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.radiusXName) ? Double.valueOf(((Arc)this.sceneGraphObject).getRadiusX()) : (propertyName.equals(this.radiusYName) ? Double.valueOf(((Arc)this.sceneGraphObject).getRadiusY()) : null);
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((Arc)this.sceneGraphObject).getRadiusX(), this.originalRadiusX)) {
            result.put(this.radiusXName, ((Arc)this.sceneGraphObject).getRadiusX());
        }
        if (!MathUtils.equals(((Arc)this.sceneGraphObject).getRadiusY(), this.originalRadiusY)) {
            result.put(this.radiusYName, ((Arc)this.sceneGraphObject).getRadiusY());
        }
        return result;
    }

    private double computeRadiusXForWidth(double width) {
        return width / this.canonicalBounds.getWidth();
    }

    private double computeRadiusYForHeight(double height) {
        return height / this.canonicalBounds.getHeight();
    }

    private Bounds computeCanonicalBounds() {
        Arc arc = new Arc();
        arc.setStartAngle(((Arc)this.sceneGraphObject).getStartAngle());
        arc.setLength(((Arc)this.sceneGraphObject).getLength());
        arc.setRadiusX(1.0);
        arc.setRadiusY(1.0);
        assert (arc.getLayoutBounds().getWidth() > 0.0);
        assert (arc.getLayoutBounds().getHeight() > 0.0);
        return arc.getLayoutBounds();
    }
}

