/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer;

import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public class GridPaneColumnResizer {
    private static final PropertyName minWidthName = new PropertyName("minWidth");
    private static final PropertyName prefWidthName = new PropertyName("prefWidth");
    private static final PropertyName maxWidthName = new PropertyName("maxWidth");
    private static final PropertyName percentWidthName = new PropertyName("percentWidth");
    private final GridPane gridPane;
    private final int columnIndex;
    private final ColumnSizing originalSizing;
    private final ColumnSizing originalSizingNext;
    private final boolean usePercentSizing;
    private final double x1;
    private final double x2;
    private final double x3;
    private final double x4;
    private final double xm;

    public GridPaneColumnResizer(GridPane gridPane, int columnIndex) {
        assert (gridPane != null);
        assert (columnIndex >= 0);
        assert (columnIndex + 1 < gridPane.getColumnConstraints().size());
        this.gridPane = gridPane;
        this.columnIndex = columnIndex;
        this.originalSizing = new ColumnSizing((ColumnConstraints)gridPane.getColumnConstraints().get(columnIndex));
        this.originalSizingNext = new ColumnSizing((ColumnConstraints)gridPane.getColumnConstraints().get(columnIndex + 1));
        this.usePercentSizing = this.countPercentWidths() == Deprecation.getGridPaneColumnCount(gridPane);
        Bounds cellBounds = Deprecation.getGridPaneCellBounds(gridPane, columnIndex, 0);
        Bounds nextBounds = Deprecation.getGridPaneCellBounds(gridPane, columnIndex + 1, 0);
        this.x1 = cellBounds.getMinX();
        this.x2 = cellBounds.getMaxX();
        this.x3 = nextBounds.getMinX();
        this.x4 = nextBounds.getMaxX();
        this.xm = this.x4 - (this.x3 - this.x2);
        assert (this.x1 <= this.xm);
    }

    public GridPane getSceneGraphObject() {
        return this.gridPane;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void updateWidth(double dx) {
        double newX2 = Math.max(this.x1, Math.min(this.xm, this.x2 + dx));
        double newX3 = newX2 + (this.x3 - this.x2);
        double newCellWidth = newX2 - this.x1;
        double newNextWidth = this.x4 - newX3;
        ColumnConstraints cc = (ColumnConstraints)this.gridPane.getColumnConstraints().get(this.columnIndex);
        ColumnConstraints ccNext = (ColumnConstraints)this.gridPane.getColumnConstraints().get(this.columnIndex + 1);
        if (this.usePercentSizing) {
            double ratio = newCellWidth / (this.xm - this.x1);
            double base = this.originalSizing.getPercentWidth() + this.originalSizingNext.getPercentWidth();
            double newPercentWidth = Math.floor(ratio * base);
            double newPercentWidthNext = base - newPercentWidth;
            cc.setPercentWidth(newPercentWidth);
            ccNext.setPercentWidth(newPercentWidthNext);
        } else {
            cc.setPrefWidth(newCellWidth);
            if (cc.getMinWidth() == -1.0) {
                cc.setMinWidth(newCellWidth);
            } else {
                cc.setMinWidth(Math.min(newCellWidth, cc.getMinWidth()));
            }
            if (cc.getMaxWidth() == -1.0) {
                cc.setMaxWidth(newCellWidth);
            } else {
                cc.setMaxWidth(Math.max(newCellWidth, cc.getMaxWidth()));
            }
            ccNext.setPrefWidth(newNextWidth);
            if (ccNext.getMinWidth() == -1.0) {
                ccNext.setMinWidth(newNextWidth);
            } else {
                ccNext.setMinWidth(Math.min(newNextWidth, ccNext.getMinWidth()));
            }
            if (ccNext.getMaxWidth() == -1.0) {
                ccNext.setMaxWidth(newNextWidth);
            } else {
                ccNext.setMaxWidth(Math.max(newNextWidth, ccNext.getMaxWidth()));
            }
        }
    }

    public void revertToOriginalSize() {
        ColumnConstraints cc = (ColumnConstraints)this.gridPane.getColumnConstraints().get(this.columnIndex);
        ColumnConstraints ccNext = (ColumnConstraints)this.gridPane.getColumnConstraints().get(this.columnIndex + 1);
        this.originalSizing.applyTo(cc);
        this.originalSizingNext.applyTo(ccNext);
    }

    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        ColumnConstraints cc = (ColumnConstraints)this.gridPane.getColumnConstraints().get(this.columnIndex);
        if (!MathUtils.equals(cc.getMinWidth(), this.originalSizing.getMinWidth())) {
            result.put(minWidthName, cc.getMinWidth());
        }
        if (!MathUtils.equals(cc.getPrefWidth(), this.originalSizing.getPrefWidth())) {
            result.put(prefWidthName, cc.getPrefWidth());
        }
        if (!MathUtils.equals(cc.getMaxWidth(), this.originalSizing.getMaxWidth())) {
            result.put(maxWidthName, cc.getMaxWidth());
        }
        if (!MathUtils.equals(cc.getPercentWidth(), this.originalSizing.getPercentWidth())) {
            result.put(percentWidthName, cc.getPercentWidth());
        }
        return result;
    }

    public Map<PropertyName, Object> getChangeMapNext() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        ColumnConstraints ccNext = (ColumnConstraints)this.gridPane.getColumnConstraints().get(this.columnIndex + 1);
        if (!MathUtils.equals(ccNext.getMinWidth(), this.originalSizingNext.getMinWidth())) {
            result.put(minWidthName, ccNext.getMinWidth());
        }
        if (!MathUtils.equals(ccNext.getPrefWidth(), this.originalSizingNext.getPrefWidth())) {
            result.put(prefWidthName, ccNext.getPrefWidth());
        }
        if (!MathUtils.equals(ccNext.getMaxWidth(), this.originalSizingNext.getMaxWidth())) {
            result.put(maxWidthName, ccNext.getMaxWidth());
        }
        if (!MathUtils.equals(ccNext.getPercentWidth(), this.originalSizingNext.getPercentWidth())) {
            result.put(percentWidthName, ccNext.getPercentWidth());
        }
        return result;
    }

    private int countPercentWidths() {
        int result = 0;
        for (ColumnConstraints cc : this.gridPane.getColumnConstraints()) {
            if (cc.getPercentWidth() == -1.0) continue;
            ++result;
        }
        return result;
    }

    private static class ColumnSizing {
        private final double minWidth;
        private final double maxWidth;
        private final double prefWidth;
        private final double percentWidth;

        public ColumnSizing(ColumnConstraints cc) {
            this.minWidth = cc.getMinWidth();
            this.maxWidth = cc.getMaxWidth();
            this.prefWidth = cc.getPrefWidth();
            this.percentWidth = cc.getPercentWidth();
        }

        public double getMinWidth() {
            return this.minWidth;
        }

        public double getMaxWidth() {
            return this.maxWidth;
        }

        public double getPrefWidth() {
            return this.prefWidth;
        }

        public double getPercentWidth() {
            return this.percentWidth;
        }

        public void applyTo(ColumnConstraints cc) {
            cc.setMinWidth(this.minWidth);
            cc.setMaxWidth(this.maxWidth);
            cc.setPrefWidth(this.prefWidth);
            cc.setPercentWidth(this.percentWidth);
        }
    }
}

